/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import java.util.Locale;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class PriceChecker
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        String line = ChestShopSign.getPrice(event.getSignLines()).toUpperCase(Locale.ROOT);
        line = Properties.PRICE_PRECISION <= 0 ? line.replaceAll("\\.\\d*", "") : line.replaceAll("(\\.\\d{0," + Properties.PRICE_PRECISION + "})\\d*", "$1");
        line = line.replaceAll("(\\.\\d*[1-9])0+", "$1");
        String[] parts = (line = line.replaceAll("(\\d)\\.0+(\\D|$)", "$1$2")).split(":");
        if (parts.length > 1 && PriceChecker.isInvalid(parts[0]) ^ PriceChecker.isInvalid(parts[1])) {
            line = line.replace(':', ' ');
            parts = new String[]{line};
        }
        if (parts[0].split(" ").length > 2) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        if (line.indexOf(66) != line.lastIndexOf(66) || line.indexOf(83) != line.lastIndexOf(83)) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        if (PriceUtil.isPrice(parts[0])) {
            line = "B " + line;
        }
        if (parts.length > 1 && PriceUtil.isPrice(parts[1])) {
            line = line + " S";
        }
        if (line.length() > 15) {
            line = line.replace(" ", "");
        }
        if (line.length() > 15) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        for (String part : parts) {
            if (PriceUtil.hasSingleMultiplier(part)) continue;
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        event.setSignLine((byte)2, line);
        if (!PriceUtil.hasBuyPrice(line) && !PriceUtil.hasSellPrice(line)) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
        }
    }

    private static boolean isInvalid(String part) {
        char[] characters;
        for (char character : characters = new char[]{'B', 'S'}) {
            if (!part.contains(Character.toString(character))) continue;
            return !PriceUtil.hasPrice(part, character);
        }
        return false;
    }
}

