/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.Events.ItemParseEvent;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class PermissionChecker
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        Player player = event.getPlayer();
        if (event.getOwnerAccount() != null && !NameManager.canUseName(player, Permission.OTHER_NAME_CREATE, event.getOwnerAccount().getShortName())) {
            event.setSignLine((byte)0, "");
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION);
            return;
        }
        String priceLine = ChestShopSign.getPrice(event.getSignLines());
        String itemLine = ChestShopSign.getItem(event.getSignLines());
        ItemParseEvent parseEvent = new ItemParseEvent(itemLine);
        Bukkit.getPluginManager().callEvent((Event)parseEvent);
        ItemStack item = parseEvent.getItem();
        if (item == null) {
            if (PriceUtil.hasBuyPrice(priceLine) && !Permission.has((CommandSender)player, Permission.SHOP_CREATION_BUY) || PriceUtil.hasSellPrice(priceLine) && !Permission.has((CommandSender)player, Permission.SHOP_CREATION_SELL)) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION);
            }
            return;
        }
        String matID = item.getType().toString().toLowerCase(Locale.ROOT);
        String[] parts = itemLine.split("#", 2);
        if (parts.length == 2 && Permission.hasPermissionSetFalse((CommandSender)player, (Object)((Object)Permission.SHOP_CREATION_ID) + matID + "#" + parts[1])) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION);
            return;
        }
        if (PriceUtil.hasBuyPrice(priceLine)) {
            if (Permission.has((CommandSender)player, (Object)((Object)Permission.SHOP_CREATION_BUY_ID) + matID)) {
                return;
            }
            if (Permission.has((CommandSender)player, Permission.SHOP_CREATION) || Permission.has((CommandSender)player, (Object)((Object)Permission.SHOP_CREATION_ID) + matID) && Permission.has((CommandSender)player, Permission.SHOP_CREATION_BUY)) {
                return;
            }
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION);
            return;
        }
        if (PriceUtil.hasSellPrice(priceLine)) {
            if (Permission.has((CommandSender)player, (Object)((Object)Permission.SHOP_CREATION_SELL_ID) + matID)) {
                return;
            }
            if (Permission.has((CommandSender)player, Permission.SHOP_CREATION) || Permission.has((CommandSender)player, (Object)((Object)Permission.SHOP_CREATION_ID) + matID) && Permission.has((CommandSender)player, Permission.SHOP_CREATION_SELL)) {
                return;
            }
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION);
            return;
        }
    }
}

