/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Database.Account;
import com.Acrobot.ChestShop.Events.AccountQueryEvent;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class NameChecker
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        NameChecker.handleEvent(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public static void onPreShopCreationHighest(PreShopCreationEvent event) {
        NameChecker.handleEvent(event);
    }

    private static void handleEvent(PreShopCreationEvent event) {
        Account account;
        block9: {
            String name = ChestShopSign.getOwner(event.getSignLines());
            Player player = event.getPlayer();
            account = event.getOwnerAccount();
            if (account == null || !account.getShortName().equalsIgnoreCase(name)) {
                account = null;
                try {
                    if (name.isEmpty() || !NameManager.canUseName(player, Permission.OTHER_NAME_CREATE, name)) {
                        account = NameManager.getOrCreateAccount((OfflinePlayer)player);
                        break block9;
                    }
                    AccountQueryEvent accountQueryEvent = new AccountQueryEvent(name);
                    ChestShop.callEvent(accountQueryEvent);
                    account = accountQueryEvent.getAccount();
                    if (account != null) break block9;
                    Player otherPlayer = ChestShop.getBukkitServer().getPlayer(name);
                    try {
                        if (otherPlayer != null) {
                            account = NameManager.getOrCreateAccount((OfflinePlayer)otherPlayer);
                            break block9;
                        }
                        account = NameManager.getOrCreateAccount(ChestShop.getBukkitServer().getOfflinePlayer(name));
                    }
                    catch (IllegalArgumentException e) {
                        event.getPlayer().sendMessage(e.getMessage());
                    }
                }
                catch (Exception e) {
                    ChestShop.getBukkitLogger().log(Level.SEVERE, "Error while trying to check account for name " + name + " with player " + player.getName(), e);
                }
            }
        }
        event.setOwnerAccount(account);
        if (account != null) {
            event.setSignLine((byte)0, account.getShortName());
        } else {
            event.setSignLine((byte)0, "");
            event.setOutcome(PreShopCreationEvent.CreationOutcome.UNKNOWN_PLAYER);
        }
    }
}

