/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.ItemParseEvent;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.ItemUtil;
import com.Acrobot.ChestShop.Utils.uBlock;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Container;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ItemChecker
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        String itemCode = ChestShopSign.getItem(event.getSignLines());
        ItemParseEvent parseEvent = new ItemParseEvent(itemCode);
        Bukkit.getPluginManager().callEvent((Event)parseEvent);
        ItemStack item = parseEvent.getItem();
        if (item == null) {
            if (Properties.ALLOW_AUTO_ITEM_FILL && itemCode.equals("?")) {
                Container container = uBlock.findConnectedContainer(event.getSign());
                if (container != null) {
                    for (ItemStack stack : container.getInventory().getContents()) {
                        if (MaterialUtil.isEmpty(stack)) continue;
                        item = stack;
                        break;
                    }
                }
                if (item == null) {
                    event.setSignLine((byte)3, ChatColor.BOLD + "?");
                    event.setOutcome(PreShopCreationEvent.CreationOutcome.ITEM_AUTOFILL);
                    return;
                }
            } else {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_ITEM);
                return;
            }
        }
        if (StringUtil.getMinecraftStringWidth(itemCode = ItemUtil.getSignName(item)) > MaterialUtil.MAXIMUM_SIGN_WIDTH) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_ITEM);
            return;
        }
        event.setSignLine((byte)3, itemCode);
    }

    private static boolean isSameItem(String newCode, ItemStack item) {
        ItemParseEvent parseEvent = new ItemParseEvent(newCode);
        Bukkit.getPluginManager().callEvent((Event)parseEvent);
        ItemStack newItem = parseEvent.getItem();
        return newItem != null && MaterialUtil.equals(newItem, item);
    }

    private static String getMetadata(String itemCode) {
        Matcher m = MaterialUtil.METADATA.matcher(itemCode);
        if (!m.find()) {
            return "";
        }
        return m.group();
    }
}

