/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Security;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import org.bukkit.block.Container;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class ChestChecker
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        String nameLine = ChestShopSign.getOwner(event.getSignLines());
        Container connectedContainer = uBlock.findConnectedContainer(event.getSign().getBlock());
        if (connectedContainer == null) {
            if (!ChestShopSign.isAdminShop(nameLine)) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_CHEST);
            }
            return;
        }
        Player player = event.getPlayer();
        if (Permission.has((CommandSender)player, Permission.ADMIN)) {
            return;
        }
        if (!Security.canAccess(player, connectedContainer.getBlock())) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION_FOR_CHEST);
        }
    }
}

