/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PostTransaction;

import com.Acrobot.Breeze.Utils.ImplementationAdapter;
import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ItemManager
implements Listener {
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public static void shopItemRemover(TransactionEvent event) {
        if (event.getTransactionType() != TransactionEvent.TransactionType.BUY) {
            return;
        }
        ItemManager.transferItems(event.getOwnerInventory(), event.getClientInventory(), event.getStock());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public static void inventoryItemRemover(TransactionEvent event) {
        if (event.getTransactionType() != TransactionEvent.TransactionType.SELL) {
            return;
        }
        ItemManager.transferItems(event.getClientInventory(), event.getOwnerInventory(), event.getStock());
    }

    private static void transferItems(Inventory sourceInventory, Inventory targetInventory, ItemStack[] items) {
        if (Properties.STACK_TO_64) {
            for (ItemStack item : items) {
                InventoryUtil.transfer(item, sourceInventory, targetInventory, 64);
            }
        } else {
            for (ItemStack item : items) {
                InventoryUtil.transfer(item, sourceInventory, targetInventory);
            }
        }
        ItemManager.update(sourceInventory.getHolder());
        ItemManager.update(targetInventory.getHolder());
    }

    private static void update(InventoryHolder holder) {
        if (holder instanceof Player) {
            ((Player)holder).updateInventory();
        } else if (holder instanceof BlockState) {
            ((BlockState)holder).update();
        } else if (holder instanceof DoubleChest) {
            ItemManager.update(ImplementationAdapter.getLeftSide((DoubleChest)holder, false));
            ItemManager.update(ImplementationAdapter.getRightSide((DoubleChest)holder, false));
        }
    }
}

