/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Player;

import com.Acrobot.Breeze.Utils.ImplementationAdapter;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.ShopInfoEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Security;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryHolder;

public class PlayerInventory
implements Listener {
    @EventHandler
    public static void onInventoryOpen(InventoryOpenEvent event) {
        if (!Properties.TURN_OFF_DEFAULT_PROTECTION_WHEN_PROTECTED_EXTERNALLY) {
            return;
        }
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        InventoryHolder holder = ImplementationAdapter.getHolder(event.getInventory(), false);
        if (!(holder instanceof BlockState) && !(holder instanceof DoubleChest)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        ArrayList<Block> containers = new ArrayList<Block>();
        if (holder instanceof DoubleChest) {
            InventoryHolder rightSide;
            InventoryHolder leftSide = ImplementationAdapter.getLeftSide((DoubleChest)holder, false);
            if (leftSide instanceof BlockState) {
                containers.add(((BlockState)leftSide).getBlock());
            }
            if ((rightSide = ImplementationAdapter.getRightSide((DoubleChest)holder, false)) instanceof BlockState) {
                containers.add(((BlockState)rightSide).getBlock());
            }
        } else {
            containers.add(((BlockState)holder).getBlock());
        }
        boolean canAccess = false;
        for (Block container : containers) {
            if (ChestShopSign.isShopBlock(container)) {
                if (!Security.canView(player, container, false)) continue;
                canAccess = true;
                continue;
            }
            canAccess = true;
        }
        if (!canAccess) {
            if (Permission.has((CommandSender)player, Permission.SHOPINFO)) {
                for (Block container : containers) {
                    Sign sign = uBlock.getConnectedSign(container);
                    if (sign == null) continue;
                    ChestShop.callEvent(new ShopInfoEvent((Player)event.getPlayer(), sign));
                }
            } else {
                Messages.ACCESS_DENIED.sendWithPrefix((CommandSender)event.getPlayer(), new String[0]);
            }
            event.setCancelled(true);
        }
    }
}

