/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Player;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.ImplementationAdapter;
import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Commands.AccessToggle;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Containers.AdminInventory;
import com.Acrobot.ChestShop.Database.Account;
import com.Acrobot.ChestShop.Events.AccountQueryEvent;
import com.Acrobot.ChestShop.Events.Economy.AccountCheckEvent;
import com.Acrobot.ChestShop.Events.ItemParseEvent;
import com.Acrobot.ChestShop.Events.PreTransactionEvent;
import com.Acrobot.ChestShop.Events.ShopInfoEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Security;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.ItemUtil;
import com.Acrobot.ChestShop.Utils.uBlock;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class PlayerInteract
implements Listener {
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public static void onInteract(PlayerInteractEvent event) {
        boolean notAllowedToTrade;
        Sign sign;
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Action action = event.getAction();
        Player player = event.getPlayer();
        if (Properties.USE_BUILT_IN_PROTECTION && uBlock.couldBeShopContainer(block) && (sign = uBlock.getConnectedSign(block)) != null) {
            if (!Security.canView(player, block, Properties.TURN_OFF_DEFAULT_PROTECTION_WHEN_PROTECTED_EXTERNALLY)) {
                if (Permission.has((CommandSender)player, Permission.SHOPINFO)) {
                    ChestShop.callEvent(new ShopInfoEvent(player, sign));
                    event.setCancelled(true);
                } else if (!Properties.TURN_OFF_DEFAULT_PROTECTION_WHEN_PROTECTED_EXTERNALLY) {
                    Messages.ACCESS_DENIED.send((CommandSender)player, new String[0]);
                    event.setCancelled(true);
                }
            }
            return;
        }
        if (!BlockUtil.isSign(block)) {
            return;
        }
        sign = (Sign)ImplementationAdapter.getState(block, false);
        if (!ChestShopSign.isValid(sign)) {
            return;
        }
        if (Properties.ALLOW_AUTO_ITEM_FILL && ChatColor.stripColor((String)ChestShopSign.getItem(sign)).equals("?")) {
            if (ChestShopSign.hasPermission(player, Permission.OTHER_NAME_CREATE, sign)) {
                ItemStack item = player.getInventory().getItemInMainHand();
                if (!MaterialUtil.isEmpty(item)) {
                    String itemCode;
                    event.setCancelled(true);
                    try {
                        itemCode = ItemUtil.getSignName(item);
                    }
                    catch (IllegalArgumentException e) {
                        player.sendMessage(ChatColor.RED + "Error while generating shop sign item name. Please contact an admin or take a look at the console/log!");
                        ChestShop.getPlugin().getLogger().log(Level.SEVERE, "Error while generating shop sign item name", e);
                        return;
                    }
                    String[] lines = sign.getLines();
                    lines[3] = itemCode;
                    SignChangeEvent changeEvent = new SignChangeEvent(block, player, lines);
                    ChestShop.callEvent(changeEvent);
                    if (!changeEvent.isCancelled()) {
                        for (int i = 0; i < changeEvent.getLines().length; i = (int)((byte)(i + 1))) {
                            String line = changeEvent.getLine(i);
                            sign.setLine(i, line != null ? line : "");
                        }
                        sign.update();
                    }
                } else {
                    Messages.NO_ITEM_IN_HAND.sendWithPrefix((CommandSender)player, new String[0]);
                }
            } else {
                Messages.ACCESS_DENIED.sendWithPrefix((CommandSender)player, new String[0]);
            }
            return;
        }
        boolean bl = notAllowedToTrade = ChestShopSign.isOwner(player, sign) || Properties.IGNORE_ACCESS_PERMS && ChestShopSign.canAccess(player, sign) && !AccessToggle.isIgnoring((OfflinePlayer)player);
        if (notAllowedToTrade && player.getInventory().getItemInMainHand().getType().name().contains("SIGN") && action == Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if ((player.getInventory().getItemInMainHand().getType().name().endsWith("DYE") || player.getInventory().getItemInMainHand().getType().name().endsWith("INK_SAC")) && action == Action.RIGHT_CLICK_BLOCK) {
            if (notAllowedToTrade && Properties.SIGN_DYING) {
                return;
            }
            event.setCancelled(true);
        }
        if (notAllowedToTrade && ChestShopSign.canAccess(player, sign) && !ChestShopSign.isAdminShop(sign)) {
            if (Properties.ALLOW_SIGN_CHEST_OPEN && (!Properties.IGNORE_CREATIVE_MODE || player.getGameMode() != GameMode.CREATIVE)) {
                if (player.isSneaking() || player.isInsideVehicle() || Properties.ALLOW_LEFT_CLICK_DESTROYING && action == Action.LEFT_CLICK_BLOCK) {
                    return;
                }
                event.setCancelled(true);
                PlayerInteract.showChestGUI(player, block, sign);
                return;
            }
            Messages.TRADE_DENIED_ACCESS_PERMS.sendWithPrefix((CommandSender)player, new String[0]);
            if (action == Action.RIGHT_CLICK_BLOCK) {
                event.setCancelled(true);
            }
            return;
        }
        if (action == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
        } else if (action == Action.LEFT_CLICK_BLOCK && !Properties.TURN_OFF_SIGN_PROTECTION && !ChestShopSign.canAccess(player, sign)) {
            event.setCancelled(true);
        }
        if (Properties.CHECK_ACCESS_FOR_SHOP_USE && !Security.canAccess(player, block, true)) {
            Messages.TRADE_DENIED.sendWithPrefix((CommandSender)player, new String[0]);
            return;
        }
        PreTransactionEvent pEvent = PlayerInteract.preparePreTransactionEvent(sign, player, action);
        if (pEvent == null) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)pEvent);
        if (pEvent.isCancelled()) {
            return;
        }
        TransactionEvent tEvent = new TransactionEvent(pEvent, sign);
        Bukkit.getPluginManager().callEvent((Event)tEvent);
    }

    private static PreTransactionEvent preparePreTransactionEvent(Sign sign, Player player, Action action) {
        int newAmount;
        String name = ChestShopSign.getOwner(sign);
        String prices = ChestShopSign.getPrice(sign);
        String material = ChestShopSign.getItem(sign);
        AccountQueryEvent accountQueryEvent = new AccountQueryEvent(name);
        Bukkit.getPluginManager().callEvent((Event)accountQueryEvent);
        Account account = accountQueryEvent.getAccount();
        if (account == null) {
            Messages.PLAYER_NOT_FOUND.sendWithPrefix((CommandSender)player, new String[0]);
            return null;
        }
        boolean adminShop = ChestShopSign.isAdminShop(sign);
        if (!adminShop) {
            AccountCheckEvent event = new AccountCheckEvent(account.getUuid(), player.getWorld());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.hasAccount()) {
                Messages.NO_ECONOMY_ACCOUNT.sendWithPrefix((CommandSender)player, new String[0]);
                return null;
            }
        }
        Action buy = Properties.REVERSE_BUTTONS ? Action.LEFT_CLICK_BLOCK : Action.RIGHT_CLICK_BLOCK;
        BigDecimal price = action == buy ? PriceUtil.getExactBuyPrice(prices) : PriceUtil.getExactSellPrice(prices);
        Container shopBlock = uBlock.findConnectedContainer(sign);
        Inventory ownerInventory = shopBlock != null ? shopBlock.getInventory() : null;
        ItemParseEvent parseEvent = new ItemParseEvent(material);
        Bukkit.getPluginManager().callEvent((Event)parseEvent);
        ItemStack item = parseEvent.getItem();
        if (item == null) {
            Messages.INVALID_SHOP_DETECTED.sendWithPrefix((CommandSender)player, new String[0]);
            return null;
        }
        int amount = -1;
        try {
            amount = ChestShopSign.getQuantity(sign);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (amount < 1 || amount > Properties.MAX_SHOP_AMOUNT) {
            Messages.INVALID_SHOP_PRICE.sendWithPrefix((CommandSender)player, new String[0]);
            return null;
        }
        BigDecimal pricePerItem = price.divide(BigDecimal.valueOf(amount), MathContext.DECIMAL128);
        if (Properties.SHIFT_SELLS_IN_STACKS && player.isSneaking() && !price.equals(PriceUtil.NO_PRICE) && PlayerInteract.isAllowedForShift(action == buy)) {
            int n = newAmount = adminShop ? InventoryUtil.getMaxStackSize(item) : PlayerInteract.getStackAmount(item, ownerInventory, player, action);
            if (newAmount > 0) {
                price = pricePerItem.multiply(BigDecimal.valueOf(newAmount)).setScale(Properties.PRICE_PRECISION, RoundingMode.HALF_UP);
                amount = newAmount;
            }
        } else if (Properties.SHIFT_SELLS_EVERYTHING && player.isSneaking() && !price.equals(PriceUtil.NO_PRICE) && PlayerInteract.isAllowedForShift(action == buy)) {
            if (action != buy) {
                newAmount = InventoryUtil.getAmount(item, (Inventory)player.getInventory());
                if (newAmount > 0) {
                    price = pricePerItem.multiply(BigDecimal.valueOf(newAmount)).setScale(Properties.PRICE_PRECISION, RoundingMode.HALF_UP);
                    amount = newAmount;
                }
            } else if (!adminShop && ownerInventory != null && (newAmount = InventoryUtil.getAmount(item, ownerInventory)) > 0) {
                price = pricePerItem.multiply(BigDecimal.valueOf(newAmount)).setScale(Properties.PRICE_PRECISION, RoundingMode.HALF_UP);
                amount = newAmount;
            }
        }
        item.setAmount(amount);
        ItemStack[] items = InventoryUtil.getItemsStacked(item);
        if (adminShop && (ownerInventory == null || Properties.FORCE_UNLIMITED_ADMIN_SHOP)) {
            ownerInventory = new AdminInventory(action == buy ? (ItemStack[])Arrays.stream(items).map(ItemStack::clone).toArray(ItemStack[]::new) : new ItemStack[]{});
        }
        TransactionEvent.TransactionType transactionType = action == buy ? TransactionEvent.TransactionType.BUY : TransactionEvent.TransactionType.SELL;
        return new PreTransactionEvent(ownerInventory, (Inventory)player.getInventory(), items, price, player, account, sign, transactionType);
    }

    private static boolean isAllowedForShift(boolean buyTransaction) {
        String allowed = Properties.SHIFT_ALLOWS;
        if (allowed.equalsIgnoreCase("ALL")) {
            return true;
        }
        return allowed.equalsIgnoreCase(buyTransaction ? "BUY" : "SELL");
    }

    private static int getStackAmount(ItemStack item, Inventory inventory, Player player, Action action) {
        Inventory checkedInventory;
        Action buy = Properties.REVERSE_BUTTONS ? Action.LEFT_CLICK_BLOCK : Action.RIGHT_CLICK_BLOCK;
        Object object = checkedInventory = action == buy ? inventory : player.getInventory();
        if (checkedInventory.containsAtLeast(item, InventoryUtil.getMaxStackSize(item))) {
            return InventoryUtil.getMaxStackSize(item);
        }
        return InventoryUtil.getAmount(item, checkedInventory);
    }

    @Deprecated
    public static boolean canOpenOtherShops(Player player) {
        return Permission.has((CommandSender)player, (Object)((Object)Permission.OTHER_NAME_ACCESS) + ".*");
    }

    private static void showChestGUI(Player player, Block signBlock, Sign sign) {
        Container container = uBlock.findConnectedContainer(sign);
        if (container == null) {
            Messages.NO_CHEST_DETECTED.sendWithPrefix((CommandSender)player, new String[0]);
            return;
        }
        if (!Security.canAccess(player, signBlock)) {
            return;
        }
        if (!Security.canAccess(player, container.getBlock())) {
            return;
        }
        BlockUtil.openBlockGUI((InventoryHolder)container, player);
    }
}

