/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Modules;

import com.Acrobot.Breeze.Utils.ImplementationAdapter;
import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.QuantityUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.ItemParseEvent;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import java.util.IllegalFormatException;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class StockCounterModule
implements Listener {
    private static final String PRICE_LINE_WITH_COUNT = "Q %d : C %d";

    @EventHandler(priority=EventPriority.HIGH)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        Container container;
        int quantity;
        try {
            quantity = ChestShopSign.getQuantity(event.getSignLines());
        }
        catch (IllegalArgumentException invalidQuantity) {
            return;
        }
        if (QuantityUtil.quantityLineContainsCounter(ChestShopSign.getQuantityLine(event.getSignLines()))) {
            event.setSignLine((byte)1, Integer.toString(quantity));
        }
        if (!Properties.USE_STOCK_COUNTER || Properties.FORCE_UNLIMITED_ADMIN_SHOP && ChestShopSign.isAdminShop(event.getSignLines())) {
            return;
        }
        if (Properties.MAX_SHOP_AMOUNT > 99999) {
            ChestShop.getBukkitLogger().warning("Stock counter cannot be used if MAX_SHOP_AMOUNT is over 5 digits");
            return;
        }
        ItemStack itemTradedByShop = StockCounterModule.determineItemTradedByShop(ChestShopSign.getItem(event.getSignLines()));
        if (itemTradedByShop != null && (container = uBlock.findConnectedContainer(event.getSign())) != null) {
            event.setSignLine((byte)1, StockCounterModule.getQuantityLineWithCounter(quantity, itemTradedByShop, container.getInventory()));
        }
    }

    @EventHandler
    public static void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().getType() == InventoryType.ENDER_CHEST || event.getInventory().getLocation() == null) {
            return;
        }
        InventoryHolder holder = ImplementationAdapter.getHolder(event.getInventory(), false);
        if (!uBlock.couldBeShopContainer(holder)) {
            return;
        }
        for (Sign shopSign : uBlock.findConnectedShopSigns(holder)) {
            if (!Properties.USE_STOCK_COUNTER || Properties.FORCE_UNLIMITED_ADMIN_SHOP && ChestShopSign.isAdminShop(shopSign)) {
                if (!QuantityUtil.quantityLineContainsCounter(ChestShopSign.getQuantityLine(shopSign))) continue;
                StockCounterModule.removeCounterFromQuantityLine(shopSign);
                continue;
            }
            if (Properties.MAX_SHOP_AMOUNT > 99999) {
                ChestShop.getBukkitLogger().warning("Stock counter cannot be used if MAX_SHOP_AMOUNT is over 5 digits");
                if (QuantityUtil.quantityLineContainsCounter(ChestShopSign.getQuantityLine(shopSign))) {
                    StockCounterModule.removeCounterFromQuantityLine(shopSign);
                }
                return;
            }
            StockCounterModule.updateCounterOnQuantityLine(shopSign, event.getInventory(), new ItemStack[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public static void onTransaction(TransactionEvent event) {
        String quantityLine = ChestShopSign.getQuantityLine(event.getSign());
        if (!Properties.USE_STOCK_COUNTER) {
            if (QuantityUtil.quantityLineContainsCounter(quantityLine)) {
                StockCounterModule.removeCounterFromQuantityLine(event.getSign());
            }
            return;
        }
        if (Properties.MAX_SHOP_AMOUNT > 99999) {
            ChestShop.getBukkitLogger().warning("Stock counter cannot be used if MAX_SHOP_AMOUNT is over 5 digits");
            if (QuantityUtil.quantityLineContainsCounter(quantityLine)) {
                StockCounterModule.removeCounterFromQuantityLine(event.getSign());
            }
            return;
        }
        if (Properties.FORCE_UNLIMITED_ADMIN_SHOP && ChestShopSign.isAdminShop(event.getSign())) {
            return;
        }
        for (Sign shopSign : uBlock.findConnectedShopSigns(ImplementationAdapter.getHolder(event.getOwnerInventory(), false))) {
            StockCounterModule.updateCounterOnQuantityLine(shopSign, event.getOwnerInventory(), new ItemStack[0]);
        }
    }

    public static void updateCounterOnQuantityLine(Sign sign, Inventory chestShopInventory, ItemStack ... extraItems) {
        int quantity;
        ItemStack itemTradedByShop = StockCounterModule.determineItemTradedByShop(sign);
        if (itemTradedByShop == null) {
            return;
        }
        try {
            quantity = ChestShopSign.getQuantity(sign);
        }
        catch (IllegalFormatException invalidQuantity) {
            return;
        }
        int numTradedItemsInChest = InventoryUtil.getAmount(itemTradedByShop, chestShopInventory);
        for (ItemStack extraStack : extraItems) {
            if (!MaterialUtil.equals(extraStack, itemTradedByShop)) continue;
            numTradedItemsInChest += extraStack.getAmount();
        }
        sign.setLine(1, String.format(PRICE_LINE_WITH_COUNT, quantity, numTradedItemsInChest));
        sign.update(true);
    }

    public static void updateCounterOnItemMoveEvent(ItemStack toAdd, InventoryHolder destinationHolder) {
        Block shopBlock = ChestShopSign.getShopBlock(destinationHolder);
        Sign connectedSign = uBlock.getConnectedSign(shopBlock);
        StockCounterModule.updateCounterOnQuantityLine(connectedSign, destinationHolder.getInventory(), toAdd);
    }

    public static void removeCounterFromQuantityLine(Sign sign) {
        int quantity;
        try {
            quantity = ChestShopSign.getQuantity(sign);
        }
        catch (IllegalFormatException invalidQuantity) {
            return;
        }
        sign.setLine(1, Integer.toString(quantity));
        sign.update(true);
    }

    public static String getQuantityLineWithCounter(int amount, ItemStack itemTransacted, Inventory chestShopInventory) {
        int numTransactionItemsInChest = InventoryUtil.getAmount(itemTransacted, chestShopInventory);
        return String.format(PRICE_LINE_WITH_COUNT, amount, numTransactionItemsInChest);
    }

    public static ItemStack determineItemTradedByShop(Sign sign) {
        return StockCounterModule.determineItemTradedByShop(ChestShopSign.getItem(sign));
    }

    public static ItemStack determineItemTradedByShop(String material) {
        ItemParseEvent parseEvent = new ItemParseEvent(material);
        Bukkit.getPluginManager().callEvent((Event)parseEvent);
        return parseEvent.getItem();
    }
}

