/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Modules;

import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Events.ChestShopReloadEvent;
import com.Acrobot.ChestShop.Events.ItemParseEvent;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.ItemUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class PriceRestrictionModule
implements Listener {
    private YamlConfiguration configuration;
    private static final double INVALID_PATH = Double.MIN_VALUE;

    public PriceRestrictionModule() {
        this.load();
    }

    private void load() {
        File file = new File(ChestShop.getFolder(), "priceLimits.yml");
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
        this.configuration.options().header("In this file you can configure maximum and minimum prices for items (when creating a shop).\nBy default, entries are read as Materials. If you wish to use other items, simply enter the name as written on the /iteminfo command.\nExact matches to the /iteminfo name are prioritised, and materials are a fallback.");
        if (!file.exists()) {
            this.configuration.addDefault("uses_materials", (Object)true);
            this.configuration.addDefault("max.buy_price.item_type", (Object)5.53);
            this.configuration.addDefault("max.buy_price.piston_head", (Object)3.51);
            this.configuration.addDefault("max.sell_price.placed_banner", (Object)3.52);
            this.configuration.addDefault("min.buy_price.piston_head", (Object)1.03);
            this.configuration.addDefault("min.sell_price.placed_banner", (Object)0.51);
            this.configuration.addDefault("max.buy_price.Powered Rail#1", (Object)3.51);
            this.configuration.addDefault("max.sell_price.Powered Rail#1", (Object)3.52);
            try {
                this.configuration.options().copyDefaults(true);
                this.configuration.save(ChestShop.loadFile("priceLimits.yml"));
            }
            catch (IOException e) {
                ChestShop.getBukkitLogger().log(Level.SEVERE, "Error while loading priceLimits.yml", e);
            }
        } else if (!this.configuration.getBoolean("uses_materials")) {
            Material testMat = Material.matchMaterial((String)"1");
            if (testMat != null) {
                ChestShop.getBukkitLogger().log(Level.INFO, "Converting numeric IDs in priceLimits.yml to Material names...");
                this.convertToMaterial("max.buy_price");
                this.convertToMaterial("max.sell_price");
                this.convertToMaterial("min.buy_price");
                this.convertToMaterial("min.sell_price");
                this.configuration.set("uses_materials", (Object)true);
                try {
                    this.configuration.save(file);
                    ChestShop.getBukkitLogger().log(Level.INFO, "Conversion finished!");
                }
                catch (IOException e) {
                    ChestShop.getBukkitLogger().log(Level.SEVERE, "Error while converting priceLimits.yml", e);
                }
            } else {
                ChestShop.getBukkitLogger().log(Level.WARNING, "Could not convert numeric IDs in priceLimits.yml to Material names!");
                ChestShop.getBukkitLogger().log(Level.WARNING, "If you want to automatically convert them you have to run this version on a pre 1.13 server.");
                ChestShop.getBukkitLogger().log(Level.WARNING, "If you want to manually convert it and hide this message set the uses_materials key to true.");
            }
        }
    }

    private void convertToMaterial(String sectionPath) {
        ConfigurationSection section = this.configuration.getConfigurationSection(sectionPath);
        if (section != null) {
            for (String typeId : section.getKeys(false)) {
                Material material = Material.matchMaterial((String)typeId);
                if (material == null) continue;
                this.configuration.set(sectionPath + "." + material.toString().toLowerCase(Locale.ROOT), this.configuration.get(sectionPath + "." + typeId));
                this.configuration.set(sectionPath + "." + typeId, null);
            }
        }
    }

    @EventHandler
    public void onReload(ChestShopReloadEvent event) {
        this.load();
    }

    private boolean isValid(String configPathToItem) {
        return this.configuration.getDouble(configPathToItem, Double.MIN_VALUE) != Double.MIN_VALUE;
    }

    private String getItemReference(String maxMinPath, ItemStack itemStack) {
        String signName = ItemUtil.getSignName(itemStack);
        return this.isValid(maxMinPath + signName) ? signName : itemStack.getType().toString().toLowerCase(Locale.ROOT);
    }

    private String getConfigPath(String maxMinPath, ItemStack itemStack) {
        return maxMinPath + this.getItemReference(maxMinPath, itemStack);
    }

    private BigDecimal getLimit(String itemConfigPath, int amount) {
        return BigDecimal.valueOf(this.configuration.getDouble(itemConfigPath) * (double)amount);
    }

    @EventHandler
    public void onPreShopCreation(PreShopCreationEvent event) {
        int amount;
        ItemParseEvent parseEvent = new ItemParseEvent(ChestShopSign.getItem(event.getSignLines()));
        Bukkit.getPluginManager().callEvent((Event)parseEvent);
        ItemStack itemStack = parseEvent.getItem();
        Player player = event.getPlayer();
        if (itemStack == null) {
            return;
        }
        try {
            amount = ChestShopSign.getQuantity(event.getSignLines());
        }
        catch (IllegalArgumentException e) {
            return;
        }
        String priceLine = ChestShopSign.getPrice(event.getSignLines());
        if (PriceUtil.hasBuyPrice(priceLine)) {
            BigDecimal buyPrice = PriceUtil.getExactBuyPrice(priceLine);
            String minBuyItemPath = this.getConfigPath("min.buy_price.", itemStack);
            BigDecimal minBuyPrice = this.getLimit(minBuyItemPath, amount);
            if (this.isValid(minBuyItemPath) && buyPrice.compareTo(minBuyPrice) < 0 && !Permission.has((CommandSender)player, Permission.NOLIMIT_MIN_BUY) && !Permission.has((CommandSender)player, (Object)((Object)Permission.NOLIMIT_MIN_BUY_ID) + this.getItemReference("min.buy_price.", itemStack))) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.BUY_PRICE_BELOW_MIN);
                Messages.BUY_PRICE_BELOW_MIN.sendWithPrefix((CommandSender)player, "price", buyPrice.toPlainString(), "minprice", minBuyPrice.toPlainString());
            }
            String maxBuyItemPath = this.getConfigPath("max.buy_price.", itemStack);
            BigDecimal maxBuyPrice = this.getLimit(maxBuyItemPath, amount);
            if (this.isValid(maxBuyItemPath) && buyPrice.compareTo(maxBuyPrice) > 0 && !Permission.has((CommandSender)player, Permission.NOLIMIT_MAX_BUY) && !Permission.has((CommandSender)player, (Object)((Object)Permission.NOLIMIT_MAX_BUY_ID) + this.getItemReference("max.buy_price.", itemStack))) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.BUY_PRICE_ABOVE_MAX);
                Messages.BUY_PRICE_ABOVE_MAX.sendWithPrefix((CommandSender)player, "price", buyPrice.toPlainString(), "maxprice", maxBuyPrice.toPlainString());
            }
        }
        if (PriceUtil.hasSellPrice(priceLine)) {
            BigDecimal sellPrice = PriceUtil.getExactSellPrice(priceLine);
            String minSellItemPath = this.getConfigPath("min.sell_price.", itemStack);
            BigDecimal minSellPrice = this.getLimit(minSellItemPath, amount);
            if (this.isValid(minSellItemPath) && sellPrice.compareTo(minSellPrice) < 0 && !Permission.has((CommandSender)player, Permission.NOLIMIT_MIN_SELL) && !Permission.has((CommandSender)player, (Object)((Object)Permission.NOLIMIT_MIN_SELL_ID) + this.getItemReference("min.sell_price.", itemStack))) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.SELL_PRICE_BELOW_MIN);
                Messages.SELL_PRICE_BELOW_MIN.sendWithPrefix((CommandSender)player, "price", sellPrice.toPlainString(), "minprice", minSellPrice.toPlainString());
            }
            String maxSellItemPath = this.getConfigPath("max.sell_price.", itemStack);
            BigDecimal maxSellPrice = this.getLimit(maxSellItemPath, amount);
            if (this.isValid(maxSellItemPath) && sellPrice.compareTo(maxSellPrice) > 0 && !Permission.has((CommandSender)player, Permission.NOLIMIT_MAX_SELL) && !Permission.has((CommandSender)player, (Object)((Object)Permission.NOLIMIT_MAX_SELL_ID) + this.getItemReference("max.sell_price.", itemStack))) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.SELL_PRICE_ABOVE_MAX);
                Messages.SELL_PRICE_ABOVE_MAX.sendWithPrefix((CommandSender)player, "price", sellPrice.toPlainString(), "maxprice", maxSellPrice.toPlainString());
            }
        }
    }
}

