/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Modules;

import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class MetricsModule
implements Listener {
    private static final long RESET_MINUTES = 30L;
    private static long lastReset = System.currentTimeMillis();
    private static int buyTransactionsLast = -1;
    private static int sellTransactionsLast = -1;
    private static long buyTransactionsCurrent = 0L;
    private static long sellTransactionsCurrent = 0L;
    private static int boughtItemsLast = -1;
    private static int soldItemsLast = -1;
    private static long boughtItemsCurrent = 0L;
    private static long soldItemsCurrent = 0L;

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public static void onTransaction(TransactionEvent event) {
        MetricsModule.checkReset();
        switch (event.getTransactionType()) {
            case BUY: {
                ++buyTransactionsCurrent;
                for (ItemStack itemStack : event.getStock()) {
                    boughtItemsCurrent += (long)itemStack.getAmount();
                }
                break;
            }
            case SELL: {
                ++sellTransactionsCurrent;
                for (ItemStack itemStack : event.getStock()) {
                    soldItemsCurrent += (long)itemStack.getAmount();
                }
                break;
            }
        }
    }

    public static int getBuyTransactions() {
        MetricsModule.checkReset();
        return buyTransactionsLast > -1 ? buyTransactionsLast : NumberUtil.toInt(buyTransactionsCurrent);
    }

    public static int getSellTransactions() {
        MetricsModule.checkReset();
        return sellTransactionsLast > -1 ? sellTransactionsLast : NumberUtil.toInt(sellTransactionsCurrent);
    }

    public static int getTotalTransactions() {
        MetricsModule.checkReset();
        return MetricsModule.getBuyTransactions() + MetricsModule.getSellTransactions();
    }

    public static int getBoughtItemsCount() {
        MetricsModule.checkReset();
        return boughtItemsLast > -1 ? boughtItemsLast : NumberUtil.toInt(boughtItemsCurrent);
    }

    public static int getSoldItemsCount() {
        MetricsModule.checkReset();
        return soldItemsLast > -1 ? soldItemsLast : NumberUtil.toInt(soldItemsCurrent);
    }

    public static int getTotalItemsCount() {
        MetricsModule.checkReset();
        return MetricsModule.getBoughtItemsCount() + MetricsModule.getSoldItemsCount();
    }

    private static void checkReset() {
        if (lastReset + 1800000L < System.currentTimeMillis()) {
            lastReset = System.currentTimeMillis();
            buyTransactionsLast = NumberUtil.toInt(buyTransactionsCurrent);
            buyTransactionsCurrent = 0L;
            sellTransactionsLast = NumberUtil.toInt(sellTransactionsCurrent);
            sellTransactionsCurrent = 0L;
            boughtItemsLast = NumberUtil.toInt(boughtItemsCurrent);
            boughtItemsCurrent = 0L;
            soldItemsLast = NumberUtil.toInt(soldItemsCurrent);
            soldItemsCurrent = 0L;
        }
    }
}

