/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Modules;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.ChestShopReloadEvent;
import com.Acrobot.ChestShop.Events.ItemParseEvent;
import com.Acrobot.ChestShop.Events.ItemStringQueryEvent;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class ItemAliasModule
implements Listener {
    private YamlConfiguration configuration;
    private BiMap<String, String> aliases;

    public ItemAliasModule() {
        this.load();
    }

    private void load() {
        File file = new File(ChestShop.getFolder(), "itemAliases.yml");
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
        this.configuration.options().header("This file specified optional aliases for certain item codes. (Use the full name from /iteminfo)\nPlease note that these aliases should fit on a sign for it to work properly!");
        if (!file.exists()) {
            this.configuration.addDefault("Item String#3d", (Object)"My Cool Item");
            this.configuration.addDefault("Other Material#Eg", (Object)"Some other Item");
            try {
                this.configuration.options().copyDefaults(true);
                this.configuration.save(ChestShop.loadFile("itemAliases.yml"));
            }
            catch (IOException e) {
                ChestShop.getBukkitLogger().log(Level.SEVERE, "Error while saving item aliases config", e);
            }
        }
        this.aliases = HashBiMap.create((int)this.configuration.getKeys(false).size());
        for (String key : this.configuration.getKeys(false)) {
            if (!this.configuration.isString(key)) continue;
            this.aliases.put((Object)key, (Object)this.configuration.getString(key));
        }
    }

    @EventHandler
    public void onReload(ChestShopReloadEvent event) {
        this.load();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onItemParse(ItemParseEvent event) {
        String code = (String)this.aliases.inverse().get((Object)event.getItemString());
        if (code == null) {
            String[] typeParts = event.getItemString().replaceAll("(?<!^)([A-Z1-9])", "_$1").toUpperCase(Locale.ROOT).split("[ _\\-]");
            int length = Short.MAX_VALUE;
            for (Map.Entry entry : this.aliases.entrySet()) {
                String[] nameParts;
                if (((String)entry.getValue()).length() < length && ((String)entry.getValue()).toUpperCase(Locale.ROOT).startsWith(event.getItemString().toUpperCase(Locale.ROOT))) {
                    length = (short)((String)entry.getValue()).length();
                    code = (String)entry.getKey();
                    continue;
                }
                if (typeParts.length <= 1 || typeParts.length != (nameParts = ((String)entry.getValue()).toUpperCase(Locale.ROOT).split("[ _\\-]")).length) continue;
                boolean matched = true;
                for (int i = 0; i < nameParts.length; ++i) {
                    if (nameParts[i].startsWith(typeParts[i])) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                code = (String)entry.getKey();
                break;
            }
        }
        if (code != null) {
            event.setItem(MaterialUtil.getItem(code));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemStringQuery(ItemStringQueryEvent event) {
        if (event.getItemString() != null) {
            String newCode = null;
            if (this.aliases.containsKey((Object)event.getItemString())) {
                newCode = (String)this.aliases.get((Object)event.getItemString());
            } else if (!event.getItemString().contains("#")) {
                newCode = (String)this.aliases.get((Object)event.getItemString().toLowerCase(Locale.ROOT));
            } else {
                String[] parts = event.getItemString().split("#", 2);
                String lowercaseCode = parts[0].toLowerCase(Locale.ROOT) + "#" + parts[1];
                if (this.aliases.containsKey((Object)lowercaseCode)) {
                    newCode = (String)this.aliases.get((Object)lowercaseCode);
                }
            }
            if (newCode != null) {
                int width;
                if (event.getMaxWidth() > 0 && (width = StringUtil.getMinecraftStringWidth(newCode)) > event.getMaxWidth()) {
                    ChestShop.getBukkitLogger().warning("Can't use configured alias " + newCode + " as it's width (" + width + ") was wider than the allowed max width of " + event.getMaxWidth());
                    return;
                }
                event.setItemString(newCode);
            }
        }
    }
}

