/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners;

import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Events.ItemInfoEvent;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.map.MapView;
import org.bukkit.potion.PotionEffect;

public class ItemInfoListener
implements Listener {
    @EventHandler
    public static void addRepairCost(ItemInfoEvent event) {
        ItemMeta meta;
        if (event.getItem().hasItemMeta() && (meta = event.getItem().getItemMeta()) instanceof Repairable && ((Repairable)meta).getRepairCost() > 0) {
            event.addMessage(Messages.iteminfo_repaircost, "cost", String.valueOf(((Repairable)meta).getRepairCost()));
        }
    }

    @EventHandler
    public static void addEnchantment(ItemInfoEvent event) {
        ItemMeta meta;
        ItemStack item = event.getItem();
        ArrayList<String> lines = new ArrayList<String>();
        for (Map.Entry enchantment : item.getEnchantments().entrySet()) {
            lines.add(ChatColor.AQUA + StringUtil.capitalizeFirstLetter(((Enchantment)enchantment.getKey()).getName(), '_') + ' ' + NumberUtil.toRoman((Integer)enchantment.getValue()));
        }
        if (item.hasItemMeta() && (meta = item.getItemMeta()) instanceof EnchantmentStorageMeta) {
            for (Map.Entry enchantment : ((EnchantmentStorageMeta)meta).getStoredEnchants().entrySet()) {
                lines.add(ChatColor.YELLOW + StringUtil.capitalizeFirstLetter(((Enchantment)enchantment.getKey()).getName(), '_') + ' ' + NumberUtil.toRoman((Integer)enchantment.getValue()));
            }
        }
        event.addRawMessage("iteminfo_enchantments", String.join((CharSequence)"\n", lines));
    }

    @EventHandler
    public static void addLeatherColor(ItemInfoEvent event) {
        ItemMeta meta;
        if (event.getItem().hasItemMeta() && (meta = event.getItem().getItemMeta()) instanceof LeatherArmorMeta) {
            Color color = ((LeatherArmorMeta)meta).getColor();
            event.addMessage(Messages.iteminfo_leather_color, "colorred", String.valueOf(color.getRed()), "colorgreen", String.valueOf(color.getGreen()), "colorblue", String.valueOf(color.getBlue()), "colorhex", Integer.toHexString(color.asRGB()));
        }
    }

    @EventHandler
    public static void addRecipes(ItemInfoEvent event) {
        ItemMeta meta;
        if (event.getItem().hasItemMeta() && (meta = event.getItem().getItemMeta()) instanceof KnowledgeBookMeta && !((KnowledgeBookMeta)meta).getRecipes().isEmpty()) {
            event.addMessage(Messages.iteminfo_recipes, new String[0]);
            for (NamespacedKey recipe : ((KnowledgeBookMeta)meta).getRecipes()) {
                event.getSender().sendMessage(ChatColor.GRAY + recipe.toString());
            }
        }
    }

    @EventHandler
    public static void addTropicalFishInfo(ItemInfoEvent event) {
        ItemMeta meta;
        if (event.getItem().hasItemMeta() && (meta = event.getItem().getItemMeta()) instanceof TropicalFishBucketMeta && ((TropicalFishBucketMeta)meta).hasVariant()) {
            event.addMessage(Messages.iteminfo_tropical_fish, "pattern", StringUtil.capitalizeFirstLetter(((TropicalFishBucketMeta)meta).getPattern().name()), "patterncolor", StringUtil.capitalizeFirstLetter(((TropicalFishBucketMeta)meta).getPatternColor().name()), "bodycolor", StringUtil.capitalizeFirstLetter(((TropicalFishBucketMeta)meta).getBodyColor().name()));
        }
    }

    @EventHandler
    public static void addMapInfo(ItemInfoEvent event) {
        ItemMeta meta;
        if (event.getItem().hasItemMeta() && (meta = event.getItem().getItemMeta()) instanceof MapMeta) {
            if (((MapMeta)meta).getMapView() != null) {
                MapView mapView = ((MapMeta)meta).getMapView();
                event.addMessage(Messages.iteminfo_map_view, "id", String.valueOf(mapView.getId()), "x", String.valueOf(mapView.getCenterX()), "z", String.valueOf(mapView.getCenterZ()), "world", mapView.getWorld() != null ? mapView.getWorld().getName() : "unknown", "scale", StringUtil.capitalizeFirstLetter(mapView.getScale().name(), '_'), "locked", "false");
            }
            if (((MapMeta)meta).hasLocationName()) {
                event.addMessage(Messages.iteminfo_map_location, "location", String.valueOf(((MapMeta)meta).getLocationName()));
            }
        }
    }

    @EventHandler
    public static void addPotionInfo(ItemInfoEvent event) {
        ItemStack item = event.getItem();
        if (!item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof PotionMeta)) {
            return;
        }
        PotionMeta potionMeta = (PotionMeta)meta;
        StringBuilder message = new StringBuilder();
        message.append(ChatColor.GRAY);
        message.append(StringUtil.capitalizeFirstLetter(item.getType().name(), '_')).append(" of ");
        message.append(StringUtil.capitalizeFirstLetter(potionMeta.getBasePotionData().getType().name(), '_')).append(' ');
        if (potionMeta.getBasePotionData().isUpgraded()) {
            message.append("II");
        } else if (potionMeta.getBasePotionData().isExtended()) {
            message.append("+");
        }
        for (PotionEffect effect : potionMeta.getCustomEffects()) {
            message.append("\n" + ChatColor.DARK_GRAY + StringUtil.capitalizeFirstLetter(effect.getType().getName(), '_') + ' ' + NumberUtil.toTime(effect.getDuration() / 20));
        }
        event.addRawMessage("iteminfo_potion", message.toString());
    }

    @EventHandler
    public static void addBookInfo(ItemInfoEvent event) {
        if (!event.getItem().hasItemMeta()) {
            return;
        }
        ItemMeta meta = event.getItem().getItemMeta();
        if (meta instanceof BookMeta) {
            BookMeta book = (BookMeta)meta;
            event.addMessage(Messages.iteminfo_book, "title", book.getTitle(), "author", book.getAuthor(), "pages", String.valueOf(book.getPageCount()));
            if (book.hasGeneration()) {
                event.addMessage(Messages.iteminfo_book_generation, "generation", StringUtil.capitalizeFirstLetter(book.getGeneration().name(), '_'));
            }
        }
    }

    @EventHandler
    public static void addLoreInfo(ItemInfoEvent event) {
        ItemMeta meta;
        if (event.getItem().hasItemMeta() && (meta = event.getItem().getItemMeta()).hasLore()) {
            event.addMessage(Messages.iteminfo_lore, "lore", String.join((CharSequence)"\n", meta.getLore()));
        }
    }
}

