/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Economy.Plugins;

import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.Economy.AccountCheckEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyAddEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyAmountEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyCheckEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyFormatEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyHoldEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencySubtractEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyTransferEvent;
import com.Acrobot.ChestShop.Listeners.Economy.EconomyAdapter;
import java.math.BigDecimal;
import javax.annotation.Nullable;
import net.tnemc.core.Reserve;
import net.tnemc.core.economy.EconomyAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;

public class ReserveListener
extends EconomyAdapter {
    @Nullable
    private static EconomyAPI economyAPI;

    public ReserveListener(@Nullable EconomyAPI api) {
        economyAPI = api;
    }

    @Override
    @Nullable
    public EconomyAdapter.ProviderInfo getProviderInfo() {
        if (economyAPI == null) {
            return null;
        }
        return new EconomyAdapter.ProviderInfo(economyAPI.name(), economyAPI.version());
    }

    public static EconomyAPI getProvider() {
        return economyAPI;
    }

    public boolean provided() {
        return economyAPI != null;
    }

    public boolean transactionCanFail() {
        if (economyAPI == null) {
            return false;
        }
        return economyAPI.name().equals("Gringotts") || economyAPI.name().equals("GoldIsMoney") || economyAPI.name().equals("MultiCurrency") || economyAPI.name().equalsIgnoreCase("TheNewEconomy");
    }

    @Nullable
    public static ReserveListener prepareListener() {
        if (Bukkit.getPluginManager().getPlugin("Reserve") == null || !Reserve.instance().economyProvided()) {
            return null;
        }
        EconomyAPI api = Reserve.instance().economy();
        if (api == null) {
            return null;
        }
        return new ReserveListener(api);
    }

    @Override
    @EventHandler
    public void onAmountCheck(CurrencyAmountEvent event) {
        if (!this.provided() || event.wasHandled() || !event.getAmount().equals(BigDecimal.ZERO)) {
            return;
        }
        event.setAmount(economyAPI.getHoldings(event.getAccount(), event.getWorld().getName()));
        event.setHandled(true);
    }

    @Override
    @EventHandler
    public void onCurrencyCheck(CurrencyCheckEvent event) {
        if (!this.provided() || event.wasHandled() || event.hasEnough()) {
            return;
        }
        event.hasEnough(economyAPI.hasHoldings(event.getAccount(), event.getAmount(), event.getWorld().getName()));
        event.setHandled(true);
    }

    @Override
    @EventHandler
    public void onAccountCheck(AccountCheckEvent event) {
        if (!this.provided() || event.wasHandled() || event.hasAccount()) {
            return;
        }
        event.hasAccount(economyAPI.hasAccount(event.getAccount()));
        event.setHandled(true);
    }

    @Override
    @EventHandler
    public void onCurrencyFormat(CurrencyFormatEvent event) {
        if (event.wasHandled() || !event.getFormattedAmount().isEmpty()) {
            return;
        }
        if (this.provided()) {
            String formatted = economyAPI.format(event.getAmount());
            event.setFormattedAmount(Properties.STRIP_PRICE_COLORS ? ChatColor.stripColor((String)formatted) : formatted);
            event.setHandled(true);
        }
    }

    @Override
    @EventHandler
    public void onCurrencyAdd(CurrencyAddEvent event) {
        if (!this.provided() || event.wasHandled()) {
            return;
        }
        event.setHandled(economyAPI.addHoldings(event.getTarget(), event.getAmount(), event.getWorld().getName()));
    }

    @Override
    @EventHandler
    public void onCurrencySubtraction(CurrencySubtractEvent event) {
        if (!this.provided() || event.wasHandled()) {
            return;
        }
        event.setHandled(economyAPI.removeHoldings(event.getTarget(), event.getAmount(), event.getWorld().getName()));
    }

    @Override
    @EventHandler
    public void onCurrencyTransfer(CurrencyTransferEvent event) {
        this.processTransfer(event);
    }

    @Override
    @EventHandler
    public void onCurrencyHoldCheck(CurrencyHoldEvent event) {
        if (!this.provided() || event.getAccount() == null || event.wasHandled() || !this.transactionCanFail() || event.canHold()) {
            return;
        }
        String world = event.getWorld().getName();
        if (!economyAPI.hasAccount(event.getAccount())) {
            event.canHold(false);
            return;
        }
        event.canHold(economyAPI.canAddHoldings(event.getAccount(), event.getAmount(), world));
        event.setHandled(true);
    }
}

