/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Economy;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.Economy.AccountCheckEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyAddEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyAmountEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyCheckEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyFormatEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyHoldEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencySubtractEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyTransferEvent;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import java.math.BigDecimal;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.Nullable;

public abstract class EconomyAdapter
implements Listener {
    @Nullable
    public abstract ProviderInfo getProviderInfo();

    public abstract void onAmountCheck(CurrencyAmountEvent var1);

    public abstract void onCurrencyCheck(CurrencyCheckEvent var1);

    public abstract void onAccountCheck(AccountCheckEvent var1);

    public abstract void onCurrencyFormat(CurrencyFormatEvent var1);

    public abstract void onCurrencyAdd(CurrencyAddEvent var1);

    public abstract void onCurrencySubtraction(CurrencySubtractEvent var1);

    public abstract void onCurrencyTransfer(CurrencyTransferEvent var1);

    public abstract void onCurrencyHoldCheck(CurrencyHoldEvent var1);

    protected void processTransfer(CurrencyTransferEvent event) {
        if (event.wasHandled() || event.getTransactionEvent() == null || event.getTransactionEvent().isCancelled()) {
            return;
        }
        BigDecimal amountSent = event.getAmountSent();
        CurrencySubtractEvent currencySubtractEvent = new CurrencySubtractEvent(amountSent, event.getSender(), event.getWorld());
        if (!NameManager.isAdminShop(event.getSender())) {
            ChestShop.callEvent(currencySubtractEvent);
        } else {
            currencySubtractEvent.setHandled(true);
        }
        if (!currencySubtractEvent.wasHandled()) {
            return;
        }
        BigDecimal amountReceived = event.getAmountReceived().subtract(amountSent.subtract(currencySubtractEvent.getAmount()));
        CurrencyAddEvent currencyAddEvent = new CurrencyAddEvent(amountReceived, event.getReceiver(), event.getWorld());
        if (!NameManager.isAdminShop(event.getReceiver())) {
            ChestShop.callEvent(currencyAddEvent);
        } else {
            currencyAddEvent.setHandled(true);
        }
        if (currencyAddEvent.wasHandled()) {
            event.setHandled(true);
        } else {
            CurrencyAddEvent currencyResetEvent = new CurrencyAddEvent(currencySubtractEvent.getAmount(), event.getSender(), event.getWorld());
            ChestShop.callEvent(currencyResetEvent);
        }
    }

    public static class ProviderInfo {
        private final String name;
        private final String version;

        public ProviderInfo(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

