/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.ImplementationAdapter;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.Acrobot.ChestShop.Events.SignValidationEvent;
import com.Acrobot.ChestShop.Listeners.Block.Break.SignBreak;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import com.Acrobot.ChestShop.Utils.uBlock;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;

public class SignCreate
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public static void onSignChange(SignChangeEvent event) {
        Block signBlock = event.getBlock();
        if (!BlockUtil.isSign(signBlock)) {
            return;
        }
        Sign sign = (Sign)ImplementationAdapter.getState(signBlock, false);
        if (ChestShopSign.isValid(sign) && !ChestShopSign.canAccess(event.getPlayer(), sign)) {
            event.setCancelled(true);
            sign.update();
            ChestShop.logDebug("Shop sign creation at " + sign.getLocation() + " by " + event.getPlayer().getName() + " was cancelled as there already was a shop here and the player did not have permission to change it");
            return;
        }
        if (ChestShopSign.isValid(event.getLines()) && !NameManager.canUseName(event.getPlayer(), Permission.OTHER_NAME_DESTROY, ChestShopSign.getOwner(event.getLines()))) {
            event.setCancelled(true);
            sign.update();
            ChestShop.logDebug("Shop sign creation at " + sign.getLocation() + " by " + event.getPlayer().getName() + " was cancelled as they weren't able to create a shop for the account '" + ChestShopSign.getOwner(event.getLines()) + "'");
            return;
        }
        String[] lines = StringUtil.stripColourCodes(event.getLines());
        SignValidationEvent signValidationEvent = new SignValidationEvent(lines);
        ChestShop.callEvent(signValidationEvent);
        if (!signValidationEvent.isValid()) {
            if (ChestShopSign.isValid(sign)) {
                SignBreak.sendShopDestroyedEvent(sign, event.getPlayer());
            }
            return;
        }
        PreShopCreationEvent preEvent = new PreShopCreationEvent(event.getPlayer(), sign, lines);
        ChestShop.callEvent(preEvent);
        if (preEvent.getOutcome().shouldBreakSign()) {
            event.setCancelled(true);
            signBlock.breakNaturally();
            ChestShop.logDebug("Shop sign creation at " + sign.getLocation() + " by " + event.getPlayer().getName() + " was cancelled (creation outcome: " + (Object)((Object)preEvent.getOutcome()) + ") and the sign broken");
            return;
        }
        for (byte i = 0; i < preEvent.getSignLines().length && i < 4; i = (byte)(i + 1)) {
            event.setLine((int)i, preEvent.getSignLine(i));
        }
        if (preEvent.isCancelled()) {
            ChestShop.logDebug("Shop sign creation at " + sign.getLocation() + " by " + event.getPlayer().getName() + " was cancelled (creation outcome: " + (Object)((Object)preEvent.getOutcome()) + ") and sign lines were set to " + String.join((CharSequence)", ", preEvent.getSignLines()));
            return;
        }
        ShopCreatedEvent postEvent = new ShopCreatedEvent(preEvent.getPlayer(), preEvent.getSign(), uBlock.findConnectedContainer(preEvent.getSign()), preEvent.getSignLines(), preEvent.getOwnerAccount());
        ChestShop.callEvent(postEvent);
    }
}

