/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block.Break;

import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class ChestBreak
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public static void onChestBreak(BlockBreakEvent event) {
        if (!ChestBreak.canBeBroken(event.getBlock(), event.getPlayer())) {
            event.setCancelled(true);
            Messages.ACCESS_DENIED.sendWithPrefix((CommandSender)event.getPlayer(), new String[0]);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onExplosion(EntityExplodeEvent event) {
        if (event.blockList() == null || !Properties.USE_BUILT_IN_PROTECTION) {
            return;
        }
        for (Block block : event.blockList()) {
            if (ChestBreak.canBeBroken(block, null)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (!ChestBreak.canBeBroken(event.getBlock(), null)) {
            event.setCancelled(true);
        }
    }

    private static boolean canBeBroken(Block block, Player breaker) {
        if (!uBlock.couldBeShopContainer(block) || !Properties.USE_BUILT_IN_PROTECTION) {
            return true;
        }
        Sign shopSign = uBlock.getConnectedSign(block);
        if (breaker != null) {
            return ChestShopSign.hasPermission(breaker, Permission.OTHER_NAME_DESTROY, shopSign);
        }
        return shopSign == null;
    }
}

