/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block;

import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Security;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;

public class BlockPlace
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public static void onContainerPlace(BlockPlaceEvent event) {
        Block placed = event.getBlockPlaced();
        if (!uBlock.couldBeShopContainer(placed)) {
            return;
        }
        Player player = event.getPlayer();
        if (Permission.has((CommandSender)player, Permission.ADMIN)) {
            return;
        }
        if (!Security.canAccess(player, placed)) {
            Messages.ACCESS_DENIED.sendWithPrefix((CommandSender)event.getPlayer(), new String[0]);
            event.setCancelled(true);
            return;
        }
        Block neighbor = uBlock.findNeighbor(placed);
        if (neighbor != null && !Security.canAccess(event.getPlayer(), neighbor)) {
            Messages.ACCESS_DENIED.sendWithPrefix((CommandSender)event.getPlayer(), new String[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onPlaceAgainstSign(BlockPlaceEvent event) {
        Block against = event.getBlockAgainst();
        if (!ChestShopSign.isValid(against)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public static void onHopperDropperPlace(BlockPlaceEvent event) {
        Block placed = event.getBlockPlaced();
        ArrayList<BlockFace> searchDirections = new ArrayList<BlockFace>();
        switch (placed.getType()) {
            case HOPPER: {
                searchDirections.add(BlockFace.UP);
                searchDirections.add(((Directional)placed.getBlockData()).getFacing());
                break;
            }
            case DROPPER: {
                searchDirections.add(((Directional)placed.getBlockData()).getFacing());
                break;
            }
            default: {
                return;
            }
        }
        for (BlockFace face : searchDirections) {
            Block relative = placed.getRelative(face);
            if (!uBlock.couldBeShopContainer(relative) || Security.canAccess(event.getPlayer(), relative)) continue;
            Messages.ACCESS_DENIED.sendWithPrefix((CommandSender)event.getPlayer(), new String[0]);
            event.setCancelled(true);
            return;
        }
    }
}

