/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Libs.ORMlite.support;

import com.Acrobot.ChestShop.Libs.ORMlite.support.DatabaseConnection;
import com.Acrobot.ChestShop.Libs.ORMlite.support.DatabaseConnectionProxyFactory;
import java.lang.reflect.Constructor;
import java.sql.SQLException;

public class ReflectionDatabaseConnectionProxyFactory
implements DatabaseConnectionProxyFactory {
    private final Class<? extends DatabaseConnection> proxyClass;
    private final Constructor<? extends DatabaseConnection> constructor;

    public ReflectionDatabaseConnectionProxyFactory(Class<? extends DatabaseConnection> proxyClass) throws IllegalArgumentException {
        this.proxyClass = proxyClass;
        try {
            this.constructor = proxyClass.getConstructor(DatabaseConnection.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find constructor with DatabaseConnection argument in " + proxyClass);
        }
    }

    @Override
    public DatabaseConnection createProxy(DatabaseConnection realConnection) throws SQLException {
        try {
            return this.constructor.newInstance(realConnection);
        }
        catch (Exception e) {
            throw new SQLException("Could not create a new instance of " + this.proxyClass, e);
        }
    }
}

