/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Libs.ORMlite.stmt;

import com.Acrobot.ChestShop.Libs.ORMlite.dao.Dao;
import com.Acrobot.ChestShop.Libs.ORMlite.db.DatabaseType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.Libs.ORMlite.stmt.ArgumentHolder;
import com.Acrobot.ChestShop.Libs.ORMlite.stmt.PreparedUpdate;
import com.Acrobot.ChestShop.Libs.ORMlite.stmt.StatementBuilder;
import com.Acrobot.ChestShop.Libs.ORMlite.stmt.query.Clause;
import com.Acrobot.ChestShop.Libs.ORMlite.stmt.query.SetExpression;
import com.Acrobot.ChestShop.Libs.ORMlite.stmt.query.SetValue;
import com.Acrobot.ChestShop.Libs.ORMlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UpdateBuilder<T, ID>
extends StatementBuilder<T, ID> {
    private List<Clause> updateClauseList = null;
    private Long limit;

    public UpdateBuilder(DatabaseType databaseType, TableInfo<T, ID> tableInfo, Dao<T, ID> dao) {
        super(databaseType, tableInfo, dao, StatementBuilder.StatementType.UPDATE);
    }

    public PreparedUpdate<T> prepare() throws SQLException {
        return super.prepareStatement(this.limit, false);
    }

    public UpdateBuilder<T, ID> updateColumnValue(String columnName, Object value) throws SQLException {
        FieldType fieldType = this.verifyColumnName(columnName);
        if (fieldType.isForeignCollection()) {
            throw new SQLException("Can't update foreign colletion field: " + columnName);
        }
        this.addUpdateColumnToList(columnName, new SetValue(columnName, fieldType, value));
        return this;
    }

    public UpdateBuilder<T, ID> updateColumnExpression(String columnName, String expression) throws SQLException {
        FieldType fieldType = this.verifyColumnName(columnName);
        if (fieldType.isForeignCollection()) {
            throw new SQLException("Can't update foreign colletion field: " + columnName);
        }
        this.addUpdateColumnToList(columnName, new SetExpression(columnName, fieldType, expression));
        return this;
    }

    public void escapeColumnName(StringBuilder sb, String columnName) {
        this.databaseType.appendEscapedEntityName(sb, columnName);
    }

    public String escapeColumnName(String columnName) {
        StringBuilder sb = new StringBuilder(columnName.length() + 4);
        this.databaseType.appendEscapedEntityName(sb, columnName);
        return sb.toString();
    }

    public void escapeValue(StringBuilder sb, String value) {
        this.databaseType.appendEscapedWord(sb, value);
    }

    public String escapeValue(String value) {
        StringBuilder sb = new StringBuilder(value.length() + 4);
        this.databaseType.appendEscapedWord(sb, value);
        return sb.toString();
    }

    public int update() throws SQLException {
        return this.dao.update(this.prepare());
    }

    public UpdateBuilder<T, ID> limit(Long maxRows) {
        this.limit = maxRows;
        return this;
    }

    @Override
    public void reset() {
        super.reset();
        this.updateClauseList = null;
        this.limit = null;
    }

    @Override
    protected void appendStatementStart(StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
        if (this.updateClauseList == null || this.updateClauseList.isEmpty()) {
            throw new IllegalArgumentException("UPDATE statements must have at least one SET column");
        }
        sb.append("UPDATE ");
        if (this.tableInfo.getSchemaName() != null && this.tableInfo.getSchemaName().length() > 0) {
            this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getSchemaName());
            sb.append('.');
        }
        if (this.databaseType.isLimitAfterUpdateSupported()) {
            this.appendLimit(sb);
        }
        this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getTableName());
        sb.append(" SET ");
        boolean first = true;
        for (Clause clause : this.updateClauseList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            clause.appendSql(this.databaseType, null, sb, argList, null);
        }
    }

    @Override
    protected void appendStatementEnd(StringBuilder sb, List<ArgumentHolder> argList) {
        if (this.databaseType.isLimitUpdateAtEndSupported()) {
            this.appendLimit(sb);
        }
    }

    private void addUpdateColumnToList(String columnName, Clause clause) {
        if (this.updateClauseList == null) {
            this.updateClauseList = new ArrayList<Clause>();
        }
        this.updateClauseList.add(clause);
    }

    private void appendLimit(StringBuilder sb) {
        if (this.limit != null) {
            this.databaseType.appendUpdateLimitValue(sb, this.limit);
        }
    }
}

