/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Libs.ORMlite.misc;

import com.Acrobot.ChestShop.Libs.ORMlite.db.DatabaseType;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.Logger;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.LoggerFactory;
import com.Acrobot.ChestShop.Libs.ORMlite.misc.IOUtils;
import com.Acrobot.ChestShop.Libs.ORMlite.misc.WrappedDatabaseConnection;
import com.Acrobot.ChestShop.Libs.ORMlite.support.ConnectionSource;
import com.Acrobot.ChestShop.Libs.ORMlite.support.DatabaseConnection;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WrappedConnectionSource
implements ConnectionSource {
    protected static final Logger logger = LoggerFactory.getLogger(WrappedConnectionSource.class);
    private final AtomicInteger connectionCount = new AtomicInteger(0);
    protected final ConnectionSource cs;
    private final Map<DatabaseConnection, WrappedDatabaseConnection> wrappedConnections = new HashMap<DatabaseConnection, WrappedDatabaseConnection>();
    protected boolean nextForceOkay;

    public WrappedConnectionSource(ConnectionSource cs) {
        this.cs = cs;
    }

    @Override
    public DatabaseConnection getReadOnlyConnection(String tableName) throws SQLException {
        DatabaseConnection connection = this.cs.getReadOnlyConnection(tableName);
        this.connectionCount.incrementAndGet();
        WrappedDatabaseConnection wrapped = new WrappedDatabaseConnection(connection);
        DatabaseConnection proxy = wrapped.getDatabaseConnectionProxy();
        this.wrappedConnections.put(proxy, wrapped);
        logger.trace("{}: got wrapped read-only DatabaseConnection '{}', count = {}", this, (Object)wrapped, (Object)this.connectionCount);
        return proxy;
    }

    @Override
    public DatabaseConnection getReadWriteConnection(String tableName) throws SQLException {
        DatabaseConnection connection = this.cs.getReadWriteConnection(tableName);
        this.connectionCount.incrementAndGet();
        WrappedDatabaseConnection wrapped = new WrappedDatabaseConnection(connection);
        DatabaseConnection proxy = wrapped.getDatabaseConnectionProxy();
        this.wrappedConnections.put(proxy, wrapped);
        logger.trace("{}: got wrapped read-write DatabaseConnection '{}', count = {}", this, (Object)wrapped, (Object)this.connectionCount);
        return proxy;
    }

    @Override
    public void releaseConnection(DatabaseConnection proxy) throws SQLException {
        WrappedDatabaseConnection wrapped = this.wrappedConnections.remove(proxy);
        if (wrapped == null) {
            if (this.nextForceOkay) {
                return;
            }
            throw new SQLException("Tried to release unknown connection: " + proxy);
        }
        if (!wrapped.isAllStatementsClosed()) {
            throw new SQLException("Wrapped connection had open statements when released: " + wrapped);
        }
        this.cs.releaseConnection(wrapped.getDatabaseConnection());
        wrapped.close();
        this.connectionCount.decrementAndGet();
        logger.trace("{}: released wrapped DatabaseConnection '{}', count = {}", this, (Object)wrapped, (Object)this.connectionCount);
    }

    @Override
    public void close() throws Exception {
        this.cs.close();
        if (!this.isEverythingClosed()) {
            throw new SQLException("Wrapped connections were not fully closed when connection-source closed");
        }
        for (WrappedDatabaseConnection wrapped : this.wrappedConnections.values()) {
            wrapped.close();
        }
        this.wrappedConnections.clear();
    }

    @Override
    public void closeQuietly() {
        IOUtils.closeQuietly(this);
    }

    public void forceOkay() {
        this.nextForceOkay = true;
    }

    public boolean isEverythingClosed() {
        if (this.nextForceOkay) {
            this.nextForceOkay = false;
            return true;
        }
        if (this.connectionCount.get() != 0) {
            logger.error("{}: ConnectionSource has {} open connections", this, (Object)this.connectionCount);
            for (WrappedDatabaseConnection wrapped : this.wrappedConnections.values()) {
                logger.error("{}: still has wrapped DatabaseConnection '{}'", this, (Object)wrapped);
            }
            return false;
        }
        for (WrappedDatabaseConnection wrapped : this.wrappedConnections.values()) {
            if (wrapped.isAllStatementsClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean saveSpecialConnection(DatabaseConnection connection) throws SQLException {
        return this.cs.saveSpecialConnection(connection);
    }

    @Override
    public void clearSpecialConnection(DatabaseConnection connection) {
        this.cs.clearSpecialConnection(connection);
    }

    @Override
    public DatabaseConnection getSpecialConnection(String tableName) {
        return this.cs.getSpecialConnection(tableName);
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.cs.getDatabaseType();
    }

    @Override
    public boolean isOpen(String tableName) {
        return this.cs.isOpen(tableName);
    }

    @Override
    public boolean isSingleConnection(String tableName) {
        return this.cs.isSingleConnection(tableName);
    }

    public void setDatabaseType(DatabaseType databaseType) {
        try {
            Method method = this.cs.getClass().getMethod("setDatabaseType", DatabaseType.class);
            method.invoke((Object)this.cs, databaseType);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set database type", e);
        }
    }

    public int getConnectionCount() {
        return this.connectionCount.get();
    }
}

