/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Libs.ORMlite.logger;

import com.Acrobot.ChestShop.Libs.ORMlite.logger.ConsoleLogBackend;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.Level;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.LocalLogBackend;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.LogBackend;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.LogBackendFactory;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.NullLogBackend;

public enum LogBackendType implements LogBackendFactory
{
    SLF4J("com.Acrobot.ChestShop.Libs.ORMlite.logger.Slf4jLoggingLogBackend$Slf4jLoggingLogBackendFactory"),
    ANDROID("com.Acrobot.ChestShop.Libs.ORMlite.android.AndroidLogBackend$AndroidLogBackendFactory"),
    LOGBACK("com.Acrobot.ChestShop.Libs.ORMlite.logger.LogbackLogBackend$LogbackLogBackendFactory"),
    COMMONS_LOGGING("com.Acrobot.ChestShop.Libs.ORMlite.logger.CommonsLoggingLogBackend$CommonsLoggingLogBackendFactory"),
    LOG4J2("com.Acrobot.ChestShop.Libs.ORMlite.logger.Log4j2LogBackend$Log4j2LogBackendFactory"),
    LOG4J("com.Acrobot.ChestShop.Libs.ORMlite.logger.Log4jLogBackend$Log4jLogBackendFactory"),
    LOCAL(new LocalLogBackend.LocalLogBackendFactory()),
    CONSOLE(new ConsoleLogBackend.ConsoleLogBackendFactory()),
    JAVA_UTIL("com.Acrobot.ChestShop.Libs.ORMlite.logger.JavaUtilLogBackend$JavaUtilLogBackendFactory"),
    NULL(new NullLogBackend.NullLogBackendFactory());

    private final LogBackendFactory factory;

    private LogBackendType(LogBackendFactory factory) {
        this.factory = factory;
    }

    private LogBackendType(String logBackendFactoryClassName) {
        this.factory = this.detectFactory(logBackendFactoryClassName);
    }

    @Override
    public LogBackend createLogBackend(String classLabel) {
        return this.factory.createLogBackend(classLabel);
    }

    public boolean isAvailable() {
        return this == LOCAL || this != NULL && !(this.factory instanceof LocalLogBackend.LocalLogBackendFactory);
    }

    private LogBackendFactory detectFactory(String factoryClassName) {
        try {
            LogBackendFactory factory = (LogBackendFactory)Class.forName(factoryClassName).newInstance();
            factory.createLogBackend("test").isLevelEnabled(Level.INFO);
            return factory;
        }
        catch (Throwable th) {
            String queuedWarning = "Unable to create instance of class " + factoryClassName + " for log type " + this + ", using local log: " + th.getMessage();
            return new LocalLogBackend.LocalLogBackendFactory(queuedWarning);
        }
    }
}

