/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Libs.ORMlite.logger;

import com.Acrobot.ChestShop.Libs.ORMlite.logger.Level;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.LogBackend;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.LogBackendFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log4j2LogBackend
implements LogBackend {
    private final Logger logger;

    public Log4j2LogBackend(String className) {
        this.logger = LogManager.getLogger((String)className);
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case WARNING: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
            case FATAL: {
                return this.logger.isFatalEnabled();
            }
        }
        return this.logger.isInfoEnabled();
    }

    @Override
    public void log(Level level, String msg) {
        switch (level) {
            case TRACE: {
                this.logger.trace(msg);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg);
                break;
            }
            case WARNING: {
                this.logger.warn(msg);
                break;
            }
            case ERROR: {
                this.logger.error(msg);
                break;
            }
            case FATAL: {
                this.logger.fatal(msg);
                break;
            }
            default: {
                this.logger.info(msg);
            }
        }
    }

    @Override
    public void log(Level level, String msg, Throwable t) {
        switch (level) {
            case TRACE: {
                this.logger.trace(msg, t);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg, t);
                break;
            }
            case WARNING: {
                this.logger.warn(msg, t);
                break;
            }
            case ERROR: {
                this.logger.error(msg, t);
                break;
            }
            case FATAL: {
                this.logger.fatal(msg, t);
                break;
            }
            default: {
                this.logger.info(msg, t);
            }
        }
    }

    public static class Log4j2LogBackendFactory
    implements LogBackendFactory {
        @Override
        public LogBackend createLogBackend(String classLabel) {
            return new Log4j2LogBackend(classLabel);
        }
    }
}

