/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Libs.ORMlite.jdbc.db;

import com.Acrobot.ChestShop.Libs.ORMlite.db.BaseDatabaseType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.DataPersister;
import com.Acrobot.ChestShop.Libs.ORMlite.field.DataType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.FieldConverter;
import com.Acrobot.ChestShop.Libs.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.converter.CharacterCompatFieldConverter;
import java.util.List;

public class OracleDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "oracle";
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    private static final String DATABASE_NAME = "Oracle";
    private static final String BOOLEAN_INTEGER_FORMAT = "integer";

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    @Override
    protected String[] getDriverClassNames() {
        return new String[]{DRIVER_CLASS_NAME};
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    @Override
    protected void appendStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("VARCHAR2(").append(fieldWidth).append(')');
    }

    @Override
    protected void appendLongStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG");
    }

    @Override
    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendLongType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("NUMERIC");
    }

    @Override
    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG RAW");
    }

    @Override
    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG RAW");
    }

    @Override
    protected void appendBigDecimalNumericType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("NUMBER(*," + fieldWidth + ")");
    }

    @Override
    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        if (BOOLEAN_INTEGER_FORMAT.equalsIgnoreCase(fieldType.getFormat())) {
            sb.append("INTEGER");
        } else {
            sb.append("CHAR(1)");
        }
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataPersister, FieldType fieldType) {
        switch (dataPersister.getSqlType()) {
            case BOOLEAN: {
                if (BOOLEAN_INTEGER_FORMAT.equalsIgnoreCase(fieldType.getFormat())) {
                    return DataType.BOOLEAN_INTEGER.getDataPersister();
                }
                return new CharacterCompatFieldConverter(DataType.BOOLEAN_CHAR.getDataPersister());
            }
            case CHAR: {
                return new CharacterCompatFieldConverter(dataPersister);
            }
        }
        return super.getFieldConverter(dataPersister, fieldType);
    }

    @Override
    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        String seqName = fieldType.getGeneratedIdSequence();
        StringBuilder seqSb = new StringBuilder(64);
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, seqName);
        statementsBefore.add(seqSb.toString());
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    protected void configureId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
    }

    @Override
    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('\"').append(name).append('\"');
    }

    @Override
    public boolean isIdSequenceNeeded() {
        return true;
    }

    @Override
    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("SELECT ");
        this.appendEscapedEntityName(sb, sequenceName);
        sb.append(".nextval FROM dual");
    }

    @Override
    public String getPingStatement() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public boolean isOffsetSqlSupported() {
        return false;
    }

    @Override
    public boolean isBatchUseTransaction() {
        return true;
    }

    @Override
    public boolean isSelectSequenceBeforeInsert() {
        return true;
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return true;
    }
}

