/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Libs.ORMlite.field.types;

import com.Acrobot.ChestShop.Libs.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.SqlType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.types.BaseDateType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.types.DateStringFormatConfig;
import com.Acrobot.ChestShop.Libs.ORMlite.support.DatabaseResults;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class DateStringType
extends BaseDateType {
    public static int DEFAULT_WIDTH = 50;
    private static final DateStringType singleTon = new DateStringType();

    public static DateStringType getSingleton() {
        return singleTon;
    }

    private DateStringType() {
        super(SqlType.STRING);
    }

    protected DateStringType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    protected DateStringType(SqlType sqlType) {
        super(sqlType);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        DateStringFormatConfig formatConfig = DateStringType.convertDateStringConfig(fieldType, this.getDefaultDateFormatConfig());
        try {
            return DateStringType.normalizeDateString(formatConfig, defaultStr);
        }
        catch (ParseException e) {
            throw new SQLException("Problems with field " + fieldType + " parsing default date-string '" + defaultStr + "' using '" + formatConfig + "'", e);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getString(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        String value = (String)sqlArg;
        DateStringFormatConfig formatConfig = DateStringType.convertDateStringConfig(fieldType, this.getDefaultDateFormatConfig());
        try {
            return DateStringType.parseDateString(formatConfig, value);
        }
        catch (ParseException e) {
            throw new SQLException("Problems with column " + columnPos + " parsing date-string '" + value + "' using '" + formatConfig + "'", e);
        }
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        DateFormat dateFormat = DateStringType.convertDateStringConfig(fieldType, this.getDefaultDateFormatConfig()).getDateFormat();
        return dateFormat.format((Date)obj);
    }

    @Override
    public Object makeConfigObject(FieldType fieldType) {
        String format = fieldType.getFormat();
        if (format == null) {
            return this.getDefaultDateFormatConfig();
        }
        return new DateStringFormatConfig(format);
    }

    @Override
    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) throws SQLException {
        return this.sqlArgToJava(fieldType, stringValue, columnPos);
    }

    @Override
    public Class<?> getPrimaryClass() {
        return byte[].class;
    }
}

