/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Libs.ORMlite.field.converter;

import com.Acrobot.ChestShop.Libs.ORMlite.field.BaseFieldConverter;
import com.Acrobot.ChestShop.Libs.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.SqlType;
import com.Acrobot.ChestShop.Libs.ORMlite.support.DatabaseResults;
import java.sql.SQLException;

public class BooleanNumberFieldConverter
extends BaseFieldConverter {
    private static final BooleanNumberFieldConverter singleTon = new BooleanNumberFieldConverter();

    public static BooleanNumberFieldConverter getSingleton() {
        return singleTon;
    }

    @Override
    public SqlType getSqlType() {
        return SqlType.BYTE;
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        boolean bool = Boolean.parseBoolean(defaultStr);
        return bool ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        Boolean bool = (Boolean)obj;
        return bool != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getByte(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        byte arg = (Byte)sqlArg;
        return arg == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
        return this.sqlArgToJava(fieldType, Byte.parseByte(stringValue), columnPos);
    }
}

