/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Libs.ORMlite.field;

import com.Acrobot.ChestShop.Libs.ORMlite.dao.BaseForeignCollection;
import com.Acrobot.ChestShop.Libs.ORMlite.dao.Dao;
import com.Acrobot.ChestShop.Libs.ORMlite.dao.DaoManager;
import com.Acrobot.ChestShop.Libs.ORMlite.dao.EagerForeignCollection;
import com.Acrobot.ChestShop.Libs.ORMlite.dao.ForeignCollection;
import com.Acrobot.ChestShop.Libs.ORMlite.dao.LazyForeignCollection;
import com.Acrobot.ChestShop.Libs.ORMlite.dao.ObjectCache;
import com.Acrobot.ChestShop.Libs.ORMlite.dao.StreamableLazyForeignCollection;
import com.Acrobot.ChestShop.Libs.ORMlite.db.DatabaseType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.DataPersister;
import com.Acrobot.ChestShop.Libs.ORMlite.field.DataPersisterManager;
import com.Acrobot.ChestShop.Libs.ORMlite.field.DataType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.DatabaseFieldConfig;
import com.Acrobot.ChestShop.Libs.ORMlite.field.FieldConverter;
import com.Acrobot.ChestShop.Libs.ORMlite.field.ForeignCollectionField;
import com.Acrobot.ChestShop.Libs.ORMlite.field.SqlType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.types.SerializableType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.types.VoidType;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.Level;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.Logger;
import com.Acrobot.ChestShop.Libs.ORMlite.logger.LoggerFactory;
import com.Acrobot.ChestShop.Libs.ORMlite.stmt.mapped.MappedQueryForFieldEq;
import com.Acrobot.ChestShop.Libs.ORMlite.support.ConnectionSource;
import com.Acrobot.ChestShop.Libs.ORMlite.support.DatabaseConnection;
import com.Acrobot.ChestShop.Libs.ORMlite.support.DatabaseResults;
import com.Acrobot.ChestShop.Libs.ORMlite.table.DatabaseTableConfig;
import com.Acrobot.ChestShop.Libs.ORMlite.table.TableInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

public class FieldType {
    public static final String FOREIGN_ID_FIELD_SUFFIX = "_id";
    private static boolean DEFAULT_VALUE_BOOLEAN;
    private static byte DEFAULT_VALUE_BYTE;
    private static char DEFAULT_VALUE_CHAR;
    private static short DEFAULT_VALUE_SHORT;
    private static int DEFAULT_VALUE_INT;
    private static long DEFAULT_VALUE_LONG;
    private static float DEFAULT_VALUE_FLOAT;
    private static double DEFAULT_VALUE_DOUBLE;
    private final String tableName;
    private final Field field;
    private final String columnName;
    private final DatabaseFieldConfig fieldConfig;
    private final boolean isId;
    private final boolean isGeneratedId;
    private final String generatedIdSequence;
    private final Method fieldGetMethod;
    private final Method fieldSetMethod;
    private final Class<?> parentClass;
    private DataPersister dataPersister;
    private Object defaultValue;
    private Object dataTypeConfigObj;
    private FieldConverter fieldConverter;
    private FieldType foreignIdField;
    private FieldType foreignRefField;
    private FieldType foreignFieldType;
    private Dao<?, ?> foreignDao;
    private MappedQueryForFieldEq<?, ?> mappedQueryForForeignField;
    private static boolean hasStreamClass;
    private static final ThreadLocal<LevelCounters> threadLevelCounters;
    private static final Logger logger;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldType(DatabaseType databaseType, String tableName, Field field, DatabaseFieldConfig fieldConfig, Class<?> parentClass) throws SQLException {
        DataPersister dataPersister;
        Class<?> clazz;
        block46: {
            block45: {
                this.tableName = tableName;
                this.field = field;
                this.parentClass = parentClass;
                fieldConfig.postProcess();
                clazz = field.getType();
                if (fieldConfig.getDataPersister() != null) break block45;
                Class<? extends DataPersister> persisterClass = fieldConfig.getPersisterClass();
                if (persisterClass == null || persisterClass == VoidType.class) {
                    dataPersister = DataPersisterManager.lookupForField(field);
                    break block46;
                } else {
                    Object result;
                    Method method;
                    try {
                        method = persisterClass.getDeclaredMethod("getSingleton", new Class[0]);
                    }
                    catch (Exception e) {
                        throw new SQLException("Could not find getSingleton static method on class " + persisterClass, e);
                    }
                    try {
                        result = method.invoke(null, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        throw new SQLException("Could not run getSingleton method on class " + persisterClass, e.getTargetException());
                    }
                    catch (Exception e) {
                        throw new SQLException("Could not run getSingleton method on class " + persisterClass, e);
                    }
                    if (result == null) {
                        throw new SQLException("Static getSingleton method should not return null on class " + persisterClass);
                    }
                    try {
                        dataPersister = (DataPersister)result;
                    }
                    catch (Exception e) {
                        throw new SQLException("Could not cast result of static getSingleton method to DataPersister from class " + persisterClass, e);
                    }
                }
            }
            dataPersister = fieldConfig.getDataPersister();
            if (!dataPersister.isValidForField(field)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Field class ").append(clazz.getName());
                sb.append(" for field ").append(this);
                sb.append(" is not valid for type ").append(dataPersister);
                Class<?> primaryClass = dataPersister.getPrimaryClass();
                if (primaryClass != null) {
                    sb.append(", maybe should be ").append(primaryClass);
                }
                throw new IllegalArgumentException(sb.toString());
            }
        }
        String foreignColumnName = fieldConfig.getForeignColumnName();
        String defaultFieldName = field.getName();
        if (fieldConfig.isForeign() || fieldConfig.isForeignAutoRefresh() || foreignColumnName != null) {
            if (dataPersister != null && dataPersister.isPrimitive()) {
                throw new IllegalArgumentException("Field " + this + " is a primitive class " + clazz + " but marked as foreign");
            }
            defaultFieldName = foreignColumnName == null ? defaultFieldName + FOREIGN_ID_FIELD_SUFFIX : defaultFieldName + "_" + foreignColumnName;
            if (ForeignCollection.class.isAssignableFrom(clazz)) {
                throw new SQLException("Field '" + field.getName() + "' in class " + clazz + "' should use the @" + ForeignCollectionField.class.getSimpleName() + " annotation not foreign=true");
            }
        } else if (fieldConfig.isForeignCollection()) {
            if (clazz != Collection.class && !ForeignCollection.class.isAssignableFrom(clazz)) {
                throw new SQLException("Field class for '" + field.getName() + "' must be of class " + ForeignCollection.class.getSimpleName() + " or Collection.");
            }
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType)) {
                throw new SQLException("Field class for '" + field.getName() + "' must be a parameterized Collection.");
            }
            Type[] genericArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (genericArguments.length == 0) {
                throw new SQLException("Field class for '" + field.getName() + "' must be a parameterized Collection with at least 1 type.");
            }
        } else if (dataPersister == null && !fieldConfig.isForeignCollection()) {
            if (byte[].class.isAssignableFrom(clazz)) {
                throw new SQLException("ORMLite does not know how to store " + clazz + " for field '" + field.getName() + "'. byte[] fields must specify dataType=DataType.BYTE_ARRAY or SERIALIZABLE");
            }
            if (!Serializable.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("ORMLite does not know how to store " + clazz + " for field " + field.getName() + ". Use another class or a custom persister.");
            }
            if (!fieldConfig.isJavaxEntity()) {
                throw new SQLException("ORMLite does not know how to store " + clazz + " for field '" + field.getName() + "'.  Use another class, custom persister, or to serialize it use dataType=DataType.SERIALIZABLE");
            }
            dataPersister = SerializableType.getSingleton();
        }
        this.columnName = fieldConfig.getColumnName() == null ? defaultFieldName : fieldConfig.getColumnName();
        this.fieldConfig = fieldConfig;
        if (fieldConfig.isId()) {
            if (fieldConfig.isGeneratedId() || fieldConfig.getGeneratedIdSequence() != null) {
                throw new IllegalArgumentException("Must specify one of id, generatedId, and generatedIdSequence with " + field.getName());
            }
            this.isId = true;
            this.isGeneratedId = false;
            this.generatedIdSequence = null;
        } else if (fieldConfig.isGeneratedId()) {
            if (fieldConfig.getGeneratedIdSequence() != null) {
                throw new IllegalArgumentException("Must specify one of id, generatedId, and generatedIdSequence with " + field.getName());
            }
            this.isId = true;
            this.isGeneratedId = true;
            this.generatedIdSequence = databaseType.isIdSequenceNeeded() ? databaseType.generateIdSequenceName(tableName, this) : null;
        } else if (fieldConfig.getGeneratedIdSequence() != null) {
            this.isId = true;
            this.isGeneratedId = true;
            String seqName = fieldConfig.getGeneratedIdSequence();
            if (databaseType.isEntityNamesMustBeUpCase()) {
                seqName = databaseType.upCaseEntityName(seqName);
            }
            this.generatedIdSequence = seqName;
        } else {
            this.isId = false;
            this.isGeneratedId = false;
            this.generatedIdSequence = null;
        }
        if (this.isId && fieldConfig.isForeign()) {
            throw new IllegalArgumentException("Id field " + field.getName() + " cannot also be a foreign object");
        }
        if (fieldConfig.isUseGetSet()) {
            this.fieldGetMethod = DatabaseFieldConfig.findGetMethod(field, databaseType, true);
            this.fieldSetMethod = DatabaseFieldConfig.findSetMethod(field, databaseType, true);
        } else {
            if (!field.isAccessible()) {
                try {
                    this.field.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException("Could not open access to field " + field.getName() + ".  You may have to set useGetSet=true to fix.");
                }
            }
            this.fieldGetMethod = null;
            this.fieldSetMethod = null;
        }
        if (fieldConfig.isAllowGeneratedIdInsert() && !fieldConfig.isGeneratedId()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must be a generated-id if allowGeneratedIdInsert = true");
        }
        if (fieldConfig.getForeignColumnName() != null && !fieldConfig.isForeign()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must have foreign = true if foreignColumnName is set");
        }
        if (fieldConfig.isForeignAutoRefresh() && !fieldConfig.isForeign()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must have foreign = true if foreignAutoRefresh = true");
        }
        if (fieldConfig.isForeignAutoCreate() && !fieldConfig.isForeign()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must have foreign = true if foreignAutoCreate = true");
        }
        if (fieldConfig.isVersion() && (dataPersister == null || !dataPersister.isValidForVersion())) {
            throw new IllegalArgumentException("Field " + field.getName() + " is not a valid type to be a version field");
        }
        this.assignDataType(databaseType, dataPersister);
    }

    public <FT, FID> void configDaoInformation(ConnectionSource connectionSource, Class<?> parentClass) throws SQLException {
        FieldType foreignFieldType;
        MappedQueryForFieldEq mappedQueryForForeignField;
        FieldType foreignRefField;
        FieldType foreignIdField;
        Object foreignDao;
        Class<?> fieldClass = this.field.getType();
        DatabaseType databaseType = connectionSource.getDatabaseType();
        String foreignColumnName = this.fieldConfig.getForeignColumnName();
        if (this.fieldConfig.isForeignAutoRefresh() || foreignColumnName != null) {
            MappedQueryForFieldEq castMappedQueryForForeignField;
            TableInfo foreignTableInfo;
            Object castDao;
            DatabaseTableConfig<?> tableConfig = this.fieldConfig.getForeignTableConfig();
            if (tableConfig == null) {
                foreignDao = castDao = DaoManager.createDao(connectionSource, fieldClass);
                foreignTableInfo = foreignDao.getTableInfo();
            } else {
                tableConfig.extractFieldTypes(databaseType);
                foreignDao = castDao = DaoManager.createDao(connectionSource, tableConfig);
                foreignTableInfo = castDao.getTableInfo();
            }
            foreignIdField = foreignTableInfo.getIdField();
            if (foreignIdField == null) {
                throw new IllegalArgumentException("Foreign field " + fieldClass + " does not have id field");
            }
            if (foreignColumnName == null) {
                foreignRefField = foreignIdField;
            } else {
                foreignRefField = foreignTableInfo.getFieldTypeByColumnName(foreignColumnName);
                if (foreignRefField == null) {
                    throw new IllegalArgumentException("Foreign field " + fieldClass + " does not have field named '" + foreignColumnName + "'");
                }
            }
            mappedQueryForForeignField = castMappedQueryForForeignField = MappedQueryForFieldEq.build(foreignDao, foreignTableInfo, foreignRefField);
            foreignFieldType = null;
        } else if (this.fieldConfig.isForeign()) {
            Object castDao;
            if (this.dataPersister != null && this.dataPersister.isPrimitive()) {
                throw new IllegalArgumentException("Field " + this + " is a primitive class " + fieldClass + " but marked as foreign");
            }
            DatabaseTableConfig<?> tableConfig = this.fieldConfig.getForeignTableConfig();
            if (tableConfig != null) {
                tableConfig.extractFieldTypes(databaseType);
                foreignDao = castDao = DaoManager.createDao(connectionSource, tableConfig);
            } else {
                foreignDao = castDao = DaoManager.createDao(connectionSource, fieldClass);
            }
            TableInfo foreignTableInfo = foreignDao.getTableInfo();
            foreignIdField = foreignTableInfo.getIdField();
            if (foreignIdField == null) {
                throw new IllegalArgumentException("Foreign field " + fieldClass + " does not have id field");
            }
            foreignRefField = foreignIdField;
            if (this.isForeignAutoCreate() && !foreignIdField.isGeneratedId()) {
                throw new IllegalArgumentException("Field " + this.field.getName() + ", if foreignAutoCreate = true then class " + fieldClass.getSimpleName() + " must have id field with generatedId = true");
            }
            foreignFieldType = null;
            mappedQueryForForeignField = null;
        } else if (this.fieldConfig.isForeignCollection()) {
            Object foundDao;
            if (fieldClass != Collection.class && !ForeignCollection.class.isAssignableFrom(fieldClass)) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be of class " + ForeignCollection.class.getSimpleName() + " or Collection.");
            }
            Type type = this.field.getGenericType();
            if (!(type instanceof ParameterizedType)) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be a parameterized Collection.");
            }
            Type[] genericArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (genericArguments.length == 0) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be a parameterized Collection with at least 1 type.");
            }
            if (genericArguments[0] instanceof TypeVariable) {
                genericArguments = ((ParameterizedType)parentClass.getGenericSuperclass()).getActualTypeArguments();
            }
            if (!(genericArguments[0] instanceof Class)) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be a parameterized Collection whose generic argument is an entity class not: " + genericArguments[0]);
            }
            Class collectionClazz = (Class)genericArguments[0];
            DatabaseTableConfig<?> tableConfig = this.fieldConfig.getForeignTableConfig();
            if (tableConfig == null) {
                Object castDao;
                foundDao = castDao = DaoManager.createDao(connectionSource, collectionClazz);
            } else {
                Object castDao = DaoManager.createDao(connectionSource, tableConfig);
                foundDao = castDao;
            }
            foreignDao = foundDao;
            foreignFieldType = this.findForeignFieldType(collectionClazz, parentClass, (Dao<?, ?>)foundDao);
            foreignIdField = null;
            foreignRefField = null;
            mappedQueryForForeignField = null;
        } else {
            foreignIdField = null;
            foreignRefField = null;
            foreignFieldType = null;
            foreignDao = null;
            mappedQueryForForeignField = null;
        }
        this.mappedQueryForForeignField = mappedQueryForForeignField;
        this.foreignFieldType = foreignFieldType;
        this.foreignDao = foreignDao;
        this.foreignIdField = foreignIdField;
        this.foreignRefField = foreignRefField;
        if (this.foreignRefField != null) {
            this.assignDataType(databaseType, this.foreignRefField.getDataPersister());
        }
    }

    public Field getField() {
        return this.field;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public DataPersister getDataPersister() {
        return this.dataPersister;
    }

    public Object getDataTypeConfigObj() {
        return this.dataTypeConfigObj;
    }

    public SqlType getSqlType() {
        return this.fieldConverter.getSqlType();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getWidth() {
        return this.fieldConfig.getWidth();
    }

    public boolean isCanBeNull() {
        return this.fieldConfig.isCanBeNull();
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isGeneratedId() {
        return this.isGeneratedId;
    }

    public boolean isGeneratedIdSequence() {
        return this.generatedIdSequence != null;
    }

    public String getGeneratedIdSequence() {
        return this.generatedIdSequence;
    }

    public boolean isForeign() {
        return this.fieldConfig.isForeign();
    }

    public void assignField(ConnectionSource connectionSource, Object data, Object val, boolean parentObject, ObjectCache objectCache) throws SQLException {
        if (logger.isLevelEnabled(Level.TRACE)) {
            logger.trace("assiging from data {}, val {}: {}", data == null ? "null" : data.getClass(), val == null ? "null" : val.getClass(), val);
        }
        if (this.foreignRefField != null && val != null) {
            Object foreignRef = this.extractJavaFieldValue(data);
            if (foreignRef != null && foreignRef.equals(val)) {
                return;
            }
            ObjectCache foreignCache = this.foreignDao.getObjectCache();
            Object cachedVal = foreignCache == null ? null : foreignCache.get(this.getType(), val);
            if (cachedVal != null) {
                val = cachedVal;
            } else if (!parentObject) {
                val = this.createForeignObject(connectionSource, val, objectCache);
            }
        }
        if (this.fieldSetMethod == null) {
            try {
                this.field.set(data, val);
            }
            catch (IllegalArgumentException e) {
                if (val == null) {
                    throw new SQLException("Could not assign object '" + val + "' to field " + this, e);
                }
                throw new SQLException("Could not assign object '" + val + "' of type " + val.getClass() + " to field " + this, e);
            }
            catch (IllegalAccessException e) {
                throw new SQLException("Could not assign object '" + val + "' of type " + val.getClass() + "' to field " + this, e);
            }
        }
        try {
            this.fieldSetMethod.invoke(data, val);
        }
        catch (Exception e) {
            throw new SQLException("Could not call " + this.fieldSetMethod + " on object with '" + val + "' for " + this, e);
        }
    }

    public Object assignIdValue(ConnectionSource connectionSource, Object data, Number val, ObjectCache objectCache) throws SQLException {
        Object idVal = this.dataPersister.convertIdNumber(val);
        if (idVal == null) {
            throw new SQLException("Invalid class " + this.dataPersister + " for sequence-id " + this);
        }
        this.assignField(connectionSource, data, idVal, false, objectCache);
        return idVal;
    }

    public <FV> FV extractRawJavaFieldValue(Object object) throws SQLException {
        Object val;
        if (this.fieldGetMethod == null) {
            try {
                val = this.field.get(object);
            }
            catch (Exception e) {
                throw new SQLException("Could not get field value for " + this, e);
            }
        }
        try {
            val = this.fieldGetMethod.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException("Could not call " + this.fieldGetMethod + " for " + this, e);
        }
        Object converted = val;
        return (FV)converted;
    }

    public Object extractJavaFieldValue(Object object) throws SQLException {
        Object val = this.extractRawJavaFieldValue(object);
        if (this.foreignRefField != null && val != null) {
            val = this.foreignRefField.extractRawJavaFieldValue(val);
        }
        return val;
    }

    public Object extractJavaFieldToSqlArgValue(Object object) throws SQLException {
        return this.convertJavaFieldToSqlArgValue(this.extractJavaFieldValue(object));
    }

    public Object convertJavaFieldToSqlArgValue(Object fieldVal) throws SQLException {
        if (fieldVal == null) {
            return null;
        }
        return this.fieldConverter.javaToSqlArg(this, fieldVal);
    }

    public Object convertStringToJavaField(String value, int columnPos) throws SQLException {
        if (value == null) {
            return null;
        }
        return this.fieldConverter.resultStringToJava(this, value, columnPos);
    }

    public Object moveToNextValue(Object val) throws SQLException {
        if (this.dataPersister == null) {
            return null;
        }
        return this.dataPersister.moveToNextValue(val);
    }

    public FieldType getForeignIdField() {
        return this.foreignIdField;
    }

    public FieldType getForeignRefField() {
        return this.foreignRefField;
    }

    public boolean isEscapedValue() {
        return this.dataPersister.isEscapedValue();
    }

    public Enum<?> getUnknownEnumVal() {
        return this.fieldConfig.getUnknownEnumValue();
    }

    public String getFormat() {
        return this.fieldConfig.getFormat();
    }

    public boolean isUnique() {
        return this.fieldConfig.isUnique();
    }

    public boolean isUniqueCombo() {
        return this.fieldConfig.isUniqueCombo();
    }

    public String getIndexName() {
        return this.fieldConfig.getIndexName(this.tableName);
    }

    public String getUniqueIndexName() {
        return this.fieldConfig.getUniqueIndexName(this.tableName);
    }

    public boolean isEscapedDefaultValue() {
        return this.dataPersister.isEscapedDefaultValue();
    }

    public boolean isComparable() throws SQLException {
        if (this.fieldConfig.isForeignCollection()) {
            return false;
        }
        if (this.dataPersister == null) {
            throw new SQLException("Internal error.  Data-persister is not configured for field.  Please post _full_ exception with associated data objects to mailing list: " + this);
        }
        return this.dataPersister.isComparable();
    }

    public boolean isArgumentHolderRequired() {
        return this.dataPersister.isArgumentHolderRequired();
    }

    public boolean isForeignCollection() {
        return this.fieldConfig.isForeignCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <FT, FID> BaseForeignCollection<FT, FID> buildForeignCollection(Object parent, FID id) throws SQLException {
        if (this.foreignFieldType == null) {
            return null;
        }
        Dao<?, ?> castDao = this.foreignDao;
        if (!this.fieldConfig.isForeignCollectionEager()) {
            return this.createLazyForeignCollection(castDao, parent, id, this.foreignFieldType, this.fieldConfig.getForeignCollectionOrderColumnName(), this.fieldConfig.isForeignCollectionOrderAscending());
        }
        LevelCounters levelCounters = threadLevelCounters.get();
        if (levelCounters == null) {
            if (this.fieldConfig.getForeignCollectionMaxEagerLevel() == 0) {
                return this.createLazyForeignCollection(castDao, parent, id, this.foreignFieldType, this.fieldConfig.getForeignCollectionOrderColumnName(), this.fieldConfig.isForeignCollectionOrderAscending());
            }
            levelCounters = new LevelCounters();
            threadLevelCounters.set(levelCounters);
        }
        if (levelCounters.foreignCollectionLevel == 0) {
            levelCounters.foreignCollectionLevelMax = this.fieldConfig.getForeignCollectionMaxEagerLevel();
        }
        if (levelCounters.foreignCollectionLevel >= levelCounters.foreignCollectionLevelMax) {
            return this.createLazyForeignCollection(castDao, parent, id, this.foreignFieldType, this.fieldConfig.getForeignCollectionOrderColumnName(), this.fieldConfig.isForeignCollectionOrderAscending());
        }
        ++levelCounters.foreignCollectionLevel;
        try {
            EagerForeignCollection eagerForeignCollection = new EagerForeignCollection(castDao, parent, id, this.foreignFieldType, this.fieldConfig.getForeignCollectionOrderColumnName(), this.fieldConfig.isForeignCollectionOrderAscending());
            return eagerForeignCollection;
        }
        finally {
            --levelCounters.foreignCollectionLevel;
        }
    }

    public <T> T resultToJava(DatabaseResults results, Map<String, Integer> columnPositions) throws SQLException {
        Integer dbColumnPos = columnPositions.get(this.columnName);
        if (dbColumnPos == null) {
            dbColumnPos = results.findColumn(this.columnName);
            columnPositions.put(this.columnName, dbColumnPos);
        }
        Object converted = this.fieldConverter.resultToJava(this, results, dbColumnPos);
        if (this.fieldConfig.isForeign()) {
            if (results.wasNull(dbColumnPos)) {
                return null;
            }
        } else if (this.dataPersister.isPrimitive()) {
            if (this.fieldConfig.isThrowIfNull() && results.wasNull(dbColumnPos)) {
                throw new SQLException("Results value for primitive field '" + this.field.getName() + "' was an invalid null value");
            }
        } else if (!this.fieldConverter.isStreamType() && results.wasNull(dbColumnPos)) {
            return null;
        }
        return (T)converted;
    }

    public boolean isSelfGeneratedId() {
        return this.dataPersister.isSelfGeneratedId();
    }

    public boolean isAllowGeneratedIdInsert() {
        return this.fieldConfig.isAllowGeneratedIdInsert();
    }

    public String getColumnDefinition() {
        String full = this.fieldConfig.getFullColumnDefinition();
        if (full == null) {
            return this.fieldConfig.getColumnDefinition();
        }
        return full;
    }

    public boolean isForeignAutoCreate() {
        return this.fieldConfig.isForeignAutoCreate();
    }

    public boolean isVersion() {
        return this.fieldConfig.isVersion();
    }

    public Object generateId() {
        return this.dataPersister.generateId();
    }

    public boolean isReadOnly() {
        return this.fieldConfig.isReadOnly();
    }

    public <FV> FV getFieldValueIfNotDefault(Object object) throws SQLException {
        Object fieldValue = this.extractJavaFieldValue(object);
        if (this.isFieldValueDefault(fieldValue)) {
            return null;
        }
        return (FV)fieldValue;
    }

    public boolean isObjectsFieldValueDefault(Object object) throws SQLException {
        Object fieldValue = this.extractJavaFieldValue(object);
        return this.isFieldValueDefault(fieldValue);
    }

    public Object getJavaDefaultValueDefault() {
        if (this.field.getType() == Boolean.TYPE) {
            return DEFAULT_VALUE_BOOLEAN;
        }
        if (this.field.getType() == Byte.TYPE || this.field.getType() == Byte.class) {
            return DEFAULT_VALUE_BYTE;
        }
        if (this.field.getType() == Character.TYPE || this.field.getType() == Character.class) {
            return Character.valueOf(DEFAULT_VALUE_CHAR);
        }
        if (this.field.getType() == Short.TYPE || this.field.getType() == Short.class) {
            return DEFAULT_VALUE_SHORT;
        }
        if (this.field.getType() == Integer.TYPE || this.field.getType() == Integer.class) {
            return DEFAULT_VALUE_INT;
        }
        if (this.field.getType() == Long.TYPE || this.field.getType() == Long.class) {
            return DEFAULT_VALUE_LONG;
        }
        if (this.field.getType() == Float.TYPE || this.field.getType() == Float.class) {
            return Float.valueOf(DEFAULT_VALUE_FLOAT);
        }
        if (this.field.getType() == Double.TYPE || this.field.getType() == Double.class) {
            return DEFAULT_VALUE_DOUBLE;
        }
        return null;
    }

    public <T> int createWithForeignDao(T foreignData) throws SQLException {
        Dao<?, ?> castDao = this.foreignDao;
        return castDao.create(foreignData);
    }

    public static FieldType createFieldType(DatabaseType databaseType, String tableName, Field field, Class<?> parentClass) throws SQLException {
        DatabaseFieldConfig fieldConfig = DatabaseFieldConfig.fromField(databaseType, tableName, field);
        if (fieldConfig == null) {
            return null;
        }
        return new FieldType(databaseType, tableName, field, fieldConfig, parentClass);
    }

    public boolean equals(Object arg) {
        if (arg == null || arg.getClass() != this.getClass()) {
            return false;
        }
        FieldType other = (FieldType)arg;
        return this.field.equals(other.field) && (this.parentClass == null ? other.parentClass == null : this.parentClass.equals(other.parentClass));
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":name=" + this.field.getName() + ",class=" + this.field.getDeclaringClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createForeignObject(ConnectionSource connectionSource, Object val, ObjectCache objectCache) throws SQLException {
        LevelCounters levelCounters = threadLevelCounters.get();
        if (levelCounters == null) {
            if (!this.fieldConfig.isForeignAutoRefresh()) {
                return this.createForeignShell(connectionSource, val, objectCache);
            }
            levelCounters = new LevelCounters();
            threadLevelCounters.set(levelCounters);
        }
        if (levelCounters.autoRefreshLevel == 0) {
            if (!this.fieldConfig.isForeignAutoRefresh()) {
                return this.createForeignShell(connectionSource, val, objectCache);
            }
            levelCounters.autoRefreshLevelMax = this.fieldConfig.getMaxForeignAutoRefreshLevel();
        }
        if (levelCounters.autoRefreshLevel >= levelCounters.autoRefreshLevelMax) {
            return this.createForeignShell(connectionSource, val, objectCache);
        }
        if (this.mappedQueryForForeignField == null) {
            Dao<?, ?> castDao = this.foreignDao;
            MappedQueryForFieldEq<?, ?> castMappedQueryForId = MappedQueryForFieldEq.build(castDao, castDao.getTableInfo(), this.foreignIdField);
            this.mappedQueryForForeignField = castMappedQueryForId;
        }
        ++levelCounters.autoRefreshLevel;
        try {
            Object obj;
            DatabaseConnection databaseConnection = connectionSource.getReadOnlyConnection(this.tableName);
            try {
                MappedQueryForFieldEq<?, ?> castMappedQueryForForeignField = this.mappedQueryForForeignField;
                obj = castMappedQueryForForeignField.execute(databaseConnection, val, objectCache);
            }
            catch (Throwable throwable) {
                connectionSource.releaseConnection(databaseConnection);
                throw throwable;
            }
            connectionSource.releaseConnection(databaseConnection);
            return obj;
        }
        finally {
            --levelCounters.autoRefreshLevel;
            if (levelCounters.autoRefreshLevel <= 0) {
                threadLevelCounters.remove();
            }
        }
    }

    private <FT, FID> FT createForeignShell(ConnectionSource connectionSource, Object val, ObjectCache objectCache) throws SQLException {
        Dao<?, ?> castDao = this.foreignDao;
        Object foreignObject = castDao.createObjectInstance();
        this.foreignIdField.assignField(connectionSource, foreignObject, val, false, objectCache);
        return (FT)foreignObject;
    }

    private boolean isFieldValueDefault(Object fieldValue) {
        if (fieldValue == null) {
            return true;
        }
        return fieldValue.equals(this.getJavaDefaultValueDefault());
    }

    private FieldType findForeignFieldType(Class<?> clazz, Class<?> foreignClass, Dao<?, ?> foreignDao) throws SQLException {
        String foreignColumnName = this.fieldConfig.getForeignCollectionForeignFieldName();
        for (FieldType fieldType : foreignDao.getTableInfo().getFieldTypes()) {
            if (fieldType.getType() != foreignClass || foreignColumnName != null && !fieldType.getField().getName().equals(foreignColumnName)) continue;
            return fieldType;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Foreign collection class ").append(clazz.getName());
        sb.append(" for field '").append(this.field.getName()).append("' column-name does not contain a foreign field");
        if (foreignColumnName != null) {
            sb.append(" named '").append(foreignColumnName).append('\'');
        }
        sb.append(" of class ").append(foreignClass.getName());
        throw new SQLException(sb.toString());
    }

    private void assignDataType(DatabaseType databaseType, DataPersister dataPersister) throws SQLException {
        this.dataPersister = dataPersister = databaseType.getDataPersister(dataPersister, this);
        if (dataPersister == null) {
            if (!this.fieldConfig.isForeign() && !this.fieldConfig.isForeignCollection()) {
                throw new SQLException("Data persister for field " + this + " is null but the field is not a foreign or foreignCollection");
            }
            return;
        }
        this.fieldConverter = databaseType.getFieldConverter(dataPersister, this);
        if (this.isGeneratedId && !dataPersister.isValidGeneratedType()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Generated-id field '").append(this.field.getName());
            sb.append("' in ").append(this.field.getDeclaringClass().getSimpleName());
            sb.append(" can't be type ").append((Object)dataPersister.getSqlType());
            sb.append(".  Must be one of: ");
            for (DataType dataType : DataType.values()) {
                DataPersister persister = dataType.getDataPersister();
                if (persister == null || !persister.isValidGeneratedType()) continue;
                sb.append((Object)dataType).append(' ');
            }
            throw new IllegalArgumentException(sb.toString());
        }
        if (this.fieldConfig.isThrowIfNull() && !dataPersister.isPrimitive()) {
            throw new SQLException("Field " + this.field.getName() + " must be a primitive if set with throwIfNull");
        }
        if (this.isId && !dataPersister.isAppropriateId()) {
            throw new SQLException("Field '" + this.field.getName() + "' is of data type " + dataPersister + " which cannot be the ID field");
        }
        this.dataTypeConfigObj = this.fieldConverter.makeConfigObject(this);
        String defaultStr = this.fieldConfig.getDefaultValue();
        if (defaultStr == null) {
            this.defaultValue = null;
        } else {
            if (this.isGeneratedId) {
                throw new SQLException("Field '" + this.field.getName() + "' cannot be a generatedId and have a default value '" + defaultStr + "'");
            }
            this.defaultValue = this.fieldConverter.parseDefaultString(this, defaultStr);
        }
    }

    private <FT, FID> LazyForeignCollection<FT, FID> createLazyForeignCollection(Dao<FT, FID> castDao, Object parent, Object parentId, FieldType foreignFieldType, String orderColumn, boolean orderAscending) {
        if (hasStreamClass) {
            return new StreamableLazyForeignCollection<FT, FID>(castDao, parent, parentId, foreignFieldType, orderColumn, orderAscending);
        }
        return new LazyForeignCollection<FT, FID>(castDao, parent, parentId, foreignFieldType, orderColumn, orderAscending);
    }

    static {
        threadLevelCounters = new ThreadLocal();
        logger = LoggerFactory.getLogger(FieldType.class);
        try {
            Class.forName("java.util.stream.Stream");
            hasStreamClass = true;
        }
        catch (Exception e) {
            hasStreamClass = false;
        }
    }

    private static class LevelCounters {
        int autoRefreshLevel;
        int autoRefreshLevelMax;
        int foreignCollectionLevel;
        int foreignCollectionLevelMax;

        LevelCounters() {
        }
    }
}

