/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Libs.Lang.bukkit;

import com.Acrobot.ChestShop.Libs.Lang.LanguageConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class BukkitLanguageConfig
extends LanguageConfig<FileConfiguration> {
    private final Plugin plugin;

    public BukkitLanguageConfig(Plugin plugin, String resourceFolder, File configFile, String locale) {
        this(plugin, resourceFolder, configFile, locale, true);
    }

    public BukkitLanguageConfig(Plugin plugin, String resourceFolder, File configFile, String locale, boolean saveFile) {
        super(resourceFolder, configFile, locale, saveFile);
        this.plugin = plugin;
        this.saveConfigResource();
        this.loadConfig();
    }

    @Override
    public void loadConfig() {
        if (this.configFile != null && this.configFile.exists()) {
            this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
            if (this.defaultConfig != null) {
                ((FileConfiguration)this.config).setDefaults((Configuration)this.defaultConfig);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveConfigResource() {
        block15: {
            try (InputStream in = this.plugin.getResource(this.resourcePath);){
                if (in == null) {
                    if (Boolean.getBoolean("com.Acrobot.ChestShop.Libs.Lang.debug")) {
                        this.plugin.getLogger().log(Level.WARNING, "No default config '" + this.resourcePath + "' found in " + this.plugin.getName() + "'s jar file!");
                    }
                    boolean bl = false;
                    return bl;
                }
                this.defaultConfig = this.config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in));
                if (!this.saveFile || this.configFile.exists()) break block15;
                File parent = this.configFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    ((FileConfiguration)this.defaultConfig).save(this.configFile);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not save " + this.configFile.getName() + " to " + this.configFile, ex);
                }
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not load default config from " + this.resourcePath, ex);
            }
        }
        return false;
    }

    @Override
    public boolean contains(String key) {
        return this.contains(key, false);
    }

    @Override
    public boolean contains(String key, boolean checkDefault) {
        if (checkDefault) {
            return ((FileConfiguration)this.config).contains(key);
        }
        return ((FileConfiguration)this.config).get(key, null) != null;
    }

    @Override
    public String get(String key) {
        List stringList;
        String string = null;
        if (((FileConfiguration)this.config).isString(key)) {
            string = ((FileConfiguration)this.config).getString(key);
        } else if (((FileConfiguration)this.config).isList(key) && (stringList = ((FileConfiguration)this.config).getStringList(key)) != null) {
            string = String.join((CharSequence)"\n", stringList);
        }
        if (string == null) {
            return ChatColor.RED + "Missing language key " + ChatColor.YELLOW + key + ChatColor.RED + " for locale " + ChatColor.YELLOW + this.getLocale();
        }
        return string;
    }

    @Override
    public FileConfiguration getRawConfig() {
        return (FileConfiguration)this.config;
    }
}

