/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Events;

import com.Acrobot.ChestShop.Database.Account;
import com.Acrobot.ChestShop.Events.PreTransactionEvent;
import java.math.BigDecimal;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TransactionEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final TransactionType type;
    private final Inventory ownerInventory;
    private final Inventory clientInventory;
    private final Player client;
    private final Account ownerAccount;
    private final ItemStack[] stock;
    private final BigDecimal exactPrice;
    private final Sign sign;
    private boolean cancelled = false;

    public TransactionEvent(PreTransactionEvent event, Sign sign) {
        this.type = event.getTransactionType();
        this.ownerInventory = event.getOwnerInventory();
        this.clientInventory = event.getClientInventory();
        this.client = event.getClient();
        this.ownerAccount = event.getOwnerAccount();
        this.stock = event.getStock();
        this.exactPrice = event.getExactPrice();
        this.sign = sign;
    }

    public TransactionEvent(TransactionType type, Inventory ownerInventory, Inventory clientInventory, Player client, Account ownerAccount, ItemStack[] stock, BigDecimal exactPrice, Sign sign) {
        this.type = type;
        this.ownerInventory = ownerInventory;
        this.clientInventory = clientInventory;
        this.client = client;
        this.ownerAccount = ownerAccount;
        this.stock = stock;
        this.exactPrice = exactPrice;
        this.sign = sign;
    }

    @Deprecated
    public TransactionEvent(TransactionType type, Inventory ownerInventory, Inventory clientInventory, Player client, Account ownerAccount, ItemStack[] stock, double price, Sign sign) {
        this(type, ownerInventory, clientInventory, client, ownerAccount, stock, BigDecimal.valueOf(price), sign);
    }

    public TransactionType getTransactionType() {
        return this.type;
    }

    public Inventory getOwnerInventory() {
        return this.ownerInventory;
    }

    public Inventory getClientInventory() {
        return this.clientInventory;
    }

    public Player getClient() {
        return this.client;
    }

    public Account getOwnerAccount() {
        return this.ownerAccount;
    }

    @Deprecated
    public OfflinePlayer getOwner() {
        return Bukkit.getOfflinePlayer((UUID)this.ownerAccount.getUuid());
    }

    public ItemStack[] getStock() {
        return this.stock;
    }

    public BigDecimal getExactPrice() {
        return this.exactPrice;
    }

    @Deprecated
    public double getPrice() {
        return this.exactPrice.doubleValue();
    }

    public Sign getSign() {
        return this.sign;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public static enum TransactionType {
        BUY,
        SELL;

    }
}

