/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Events;

import com.Acrobot.ChestShop.Database.Account;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import java.math.BigDecimal;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PreTransactionEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Player client;
    private Account ownerAccount;
    private final TransactionEvent.TransactionType transactionType;
    private final Sign sign;
    private Inventory ownerInventory;
    private Inventory clientInventory;
    private ItemStack[] items;
    private BigDecimal exactPrice;
    private TransactionOutcome transactionOutcome = TransactionOutcome.TRANSACTION_SUCCESFUL;

    public PreTransactionEvent(Inventory ownerInventory, Inventory clientInventory, ItemStack[] items, BigDecimal exactPrice, Player client, Account ownerAccount, Sign sign, TransactionEvent.TransactionType type) {
        this.ownerInventory = ownerInventory;
        this.clientInventory = clientInventory == null ? client.getInventory() : clientInventory;
        this.items = items;
        this.exactPrice = exactPrice;
        this.client = client;
        this.ownerAccount = ownerAccount;
        this.sign = sign;
        this.transactionType = type;
    }

    @Deprecated
    public PreTransactionEvent(Inventory ownerInventory, Inventory clientInventory, ItemStack[] items, double price, Player client, Account ownerAccount, Sign sign, TransactionEvent.TransactionType type) {
        this(ownerInventory, clientInventory, items, BigDecimal.valueOf(price), client, ownerAccount, sign, type);
    }

    public Sign getSign() {
        return this.sign;
    }

    public BigDecimal getExactPrice() {
        return this.exactPrice;
    }

    public void setExactPrice(BigDecimal exactPrice) {
        this.exactPrice = exactPrice;
    }

    @Deprecated
    public double getPrice() {
        return this.exactPrice.doubleValue();
    }

    @Deprecated
    public void setPrice(double price) {
        this.exactPrice = BigDecimal.valueOf(price);
    }

    public void setStock(ItemStack ... stock) {
        this.items = stock;
    }

    public ItemStack[] getStock() {
        return this.items;
    }

    public Player getClient() {
        return this.client;
    }

    public Account getOwnerAccount() {
        return this.ownerAccount;
    }

    public void setOwnerAccount(Account ownerAccount) {
        this.ownerAccount = ownerAccount;
    }

    public Inventory getOwnerInventory() {
        return this.ownerInventory;
    }

    public void setOwnerInventory(Inventory ownerInventory) {
        this.ownerInventory = ownerInventory;
    }

    public void setClientInventory(Inventory clientInventory) {
        this.clientInventory = clientInventory;
    }

    public Inventory getClientInventory() {
        return this.clientInventory;
    }

    public TransactionEvent.TransactionType getTransactionType() {
        return this.transactionType;
    }

    public boolean isCancelled() {
        return this.transactionOutcome != TransactionOutcome.TRANSACTION_SUCCESFUL;
    }

    public void setCancelled(boolean cancel) {
        this.transactionOutcome = cancel ? TransactionOutcome.OTHER : TransactionOutcome.TRANSACTION_SUCCESFUL;
    }

    public TransactionOutcome getTransactionOutcome() {
        return this.transactionOutcome;
    }

    public void setCancelled(TransactionOutcome reason) {
        this.transactionOutcome = reason;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum TransactionOutcome {
        SHOP_DOES_NOT_BUY_THIS_ITEM,
        SHOP_DOES_NOT_SELL_THIS_ITEM,
        CLIENT_DOES_NOT_HAVE_PERMISSION,
        CLIENT_DOES_NOT_HAVE_ENOUGH_MONEY,
        SHOP_DOES_NOT_HAVE_ENOUGH_MONEY,
        CLIENT_DEPOSIT_FAILED,
        SHOP_DEPOSIT_FAILED,
        NOT_ENOUGH_SPACE_IN_CHEST,
        NOT_ENOUGH_SPACE_IN_INVENTORY,
        NOT_ENOUGH_STOCK_IN_CHEST,
        NOT_ENOUGH_STOCK_IN_INVENTORY,
        INVALID_SHOP,
        INVALID_CLIENT_NAME,
        SPAM_CLICKING_PROTECTION,
        CREATIVE_MODE_PROTECTION,
        SHOP_IS_RESTRICTED,
        OTHER,
        TRANSACTION_SUCCESFUL;

    }
}

