/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Events;

import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Libs.Kyori.adventure.text.Component;
import com.Acrobot.ChestShop.Libs.MineDown.MineDown;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class ItemInfoEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final CommandSender sender;
    private final ItemStack item;
    private final Map<String, Map.Entry<Messages.Message, String[]>> messages = new LinkedHashMap<String, Map.Entry<Messages.Message, String[]>>();

    public ItemInfoEvent(CommandSender sender, ItemStack item) {
        this.sender = sender;
        this.item = item;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void addMessage(Messages.Message message, String ... args) {
        this.messages.put(message.getKey(), new AbstractMap.SimpleEntry<Messages.Message, String[]>(message, args));
    }

    public void addMessage(String key, Messages.Message message, String ... args) {
        this.messages.put(key, new AbstractMap.SimpleEntry<Messages.Message, String[]>(message, args));
    }

    public void addRawMessage(String key, Component message) {
        this.messages.put(key, new AbstractMap.SimpleEntry<ComponentMessage, String[]>(new ComponentMessage(key, message), new String[0]));
    }

    public void addRawMessage(String key, String message) {
        this.messages.put(key, new AbstractMap.SimpleEntry<StringMessage, String[]>(new StringMessage(key, message), new String[0]));
    }

    public Collection<Map.Entry<Messages.Message, String[]>> getMessages() {
        return this.messages.values();
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static class ComponentMessage
    extends Messages.Message {
        private final Component message;

        public ComponentMessage(String key, Component message) {
            super(key);
            this.message = message;
        }

        @Override
        public Component getComponent(CommandSender sender, boolean prefixSuffix, Map<String, String> replacementMap, String ... replacements) {
            if (prefixSuffix) {
                return Messages.prefix.getComponent(sender, false, replacementMap, replacements).append(this.message);
            }
            return this.message;
        }
    }

    public static class StringMessage
    extends Messages.Message {
        private final String message;

        public StringMessage(String key, String message) {
            super(key);
            this.message = message;
        }

        @Override
        public Component getComponent(CommandSender sender, boolean prefixSuffix, Map<String, String> replacementMap, String ... replacements) {
            if (prefixSuffix) {
                return Messages.prefix.getComponent(sender, false, replacementMap, replacements).append(MineDown.parse(this.message, new String[0]));
            }
            return MineDown.parse(this.message, new String[0]);
        }
    }
}

