/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Events.Economy;

import com.Acrobot.ChestShop.Events.Economy.EconomicEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import java.math.BigDecimal;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;

public class CurrencyTransferEvent
extends EconomicEvent {
    private static final HandlerList handlers = new HandlerList();
    private BigDecimal amountSent;
    private BigDecimal amountReceived;
    private final Player initiator;
    private UUID partner;
    private Direction direction;
    private final TransactionEvent transactionEvent;

    public CurrencyTransferEvent(BigDecimal amount, Player initiator, UUID partner, Direction direction) {
        this(amount, amount, initiator, partner, direction);
    }

    public CurrencyTransferEvent(BigDecimal amountSent, BigDecimal amountReceived, Player initiator, UUID partner, Direction direction) {
        this(amountSent, amountReceived, initiator, partner, direction, null);
    }

    public CurrencyTransferEvent(BigDecimal amount, Player initiator, UUID partner, Direction direction, TransactionEvent transactionEvent) {
        this(amount, amount, initiator, partner, direction, transactionEvent);
    }

    public CurrencyTransferEvent(BigDecimal amountSent, BigDecimal amountReceived, Player initiator, UUID partner, Direction direction, TransactionEvent transactionEvent) {
        this.amountSent = amountSent;
        this.amountReceived = amountReceived;
        this.initiator = initiator;
        this.partner = partner;
        this.direction = direction;
        this.transactionEvent = transactionEvent;
    }

    @Deprecated
    public BigDecimal getAmount() {
        return this.amountSent;
    }

    @Deprecated
    public double getDoubleAmount() {
        return this.getAmount().doubleValue();
    }

    @Deprecated
    public void setAmount(BigDecimal amount) {
        this.amountSent = amount;
        this.amountReceived = amount;
    }

    @Deprecated
    public void setAmount(double amount) {
        this.setAmount(BigDecimal.valueOf(amount));
    }

    public BigDecimal getAmountSent() {
        return this.amountSent;
    }

    public void setAmountSent(BigDecimal amountSent) {
        this.amountSent = amountSent;
    }

    public BigDecimal getAmountReceived() {
        return this.amountReceived;
    }

    public void setAmountReceived(BigDecimal amountReceived) {
        this.amountReceived = amountReceived;
    }

    @Deprecated
    public boolean hasBeenTransferred() {
        return this.wasHandled();
    }

    @Deprecated
    public void setTransferred(boolean success) {
        this.setHandled(success);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public TransactionEvent getTransactionEvent() {
        return this.transactionEvent;
    }

    public Player getInitiator() {
        return this.initiator;
    }

    public UUID getPartner() {
        return this.partner;
    }

    public void setPartner(UUID partner) {
        this.partner = partner;
    }

    public World getWorld() {
        return this.initiator.getWorld();
    }

    public UUID getSender() {
        return this.direction == Direction.PARTNER ? this.initiator.getUniqueId() : this.partner;
    }

    public UUID getReceiver() {
        return this.direction == Direction.PARTNER ? this.partner : this.initiator.getUniqueId();
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum Direction {
        PARTNER,
        INITIATOR;

    }
}

