/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Listeners.Economy.EconomyAdapter;
import com.Acrobot.ChestShop.Listeners.Economy.Plugins.ReserveListener;
import com.Acrobot.ChestShop.Listeners.Economy.Plugins.VaultListener;
import com.Acrobot.ChestShop.Metrics.BStats.charts.DrilldownPie;
import com.Acrobot.ChestShop.Plugins.BlockLocker;
import com.Acrobot.ChestShop.Plugins.Deadbolt;
import com.Acrobot.ChestShop.Plugins.GriefPrevenentionBuilding;
import com.Acrobot.ChestShop.Plugins.Heroes;
import com.Acrobot.ChestShop.Plugins.ItemBridge;
import com.Acrobot.ChestShop.Plugins.LightweightChestProtection;
import com.Acrobot.ChestShop.Plugins.Lockette;
import com.Acrobot.ChestShop.Plugins.LockettePro;
import com.Acrobot.ChestShop.Plugins.RedProtectBuilding;
import com.Acrobot.ChestShop.Plugins.ResidenceChestProtection;
import com.Acrobot.ChestShop.Plugins.SimpleChestLock;
import com.Acrobot.ChestShop.Plugins.WorldGuardBuilding;
import com.Acrobot.ChestShop.Plugins.WorldGuardFlags;
import com.Acrobot.ChestShop.Plugins.WorldGuardProtection;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;

public class Dependencies
implements Listener {
    private static final Map<String, String> versions = new HashMap<String, String>();

    private static boolean isLoaded(String plugin) {
        return versions.containsKey(plugin.toLowerCase(Locale.ROOT));
    }

    public static void initializePlugins() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        for (String dependency : ChestShop.getDependencies()) {
            Plugin plugin = pluginManager.getPlugin(dependency);
            if (plugin == null) continue;
            Dependencies.initializePlugin(dependency, plugin);
        }
    }

    private static void initializePlugin(String name, Plugin plugin) {
        Dependency dependency;
        try {
            dependency = Dependency.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            return;
        }
        switch (dependency.ordinal()) {
            case 7: {
                WorldGuardFlags.ENABLE_SHOP.getName();
            }
        }
        PluginDescriptionFile description = plugin.getDescription();
        ChestShop.getBukkitLogger().info(description.getName() + " version " + description.getVersion() + " loaded.");
    }

    public static boolean loadPlugins() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        for (Dependency dependency : Dependency.values()) {
            Plugin plugin = pluginManager.getPlugin(dependency.name());
            if (plugin == null || !plugin.isEnabled()) continue;
            try {
                Dependencies.loadPlugin(dependency.name(), plugin);
            }
            catch (Exception e2) {
                plugin.getLogger().log(Level.WARNING, "Unable to hook into " + plugin.getName() + " " + plugin.getDescription().getVersion(), e2);
            }
        }
        if (Dependencies.loadEconomy()) {
            Map<String, Map> map = versions.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, ImmutableMap>((String)e.getKey(), ImmutableMap.of((Object)((String)e.getValue()), (Object)1))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
            ChestShop.getMetrics().addCustomChart(new DrilldownPie("dependencies", () -> map));
            return true;
        }
        return false;
    }

    private static boolean loadEconomy() {
        String plugin = "none";
        EconomyAdapter economy = null;
        if (Bukkit.getPluginManager().getPlugin("Reserve") != null) {
            plugin = "Reserve";
            economy = ReserveListener.prepareListener();
        }
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            plugin = "Vault";
            economy = VaultListener.initializeVault();
        }
        if (economy == null) {
            ChestShop.getBukkitLogger().severe("No Economy adapter found! You need to install either Vault or Reserve!");
            return false;
        }
        ChestShop.getMetrics().addCustomChart(ChestShop.createStaticDrilldownStat("economyAdapter", plugin, Bukkit.getPluginManager().getPlugin(plugin).getDescription().getVersion()));
        ChestShop.getMetrics().addCustomChart(ChestShop.createStaticDrilldownStat("economyPlugin", economy::getProviderInfo));
        ChestShop.registerListener(economy);
        ChestShop.getBukkitLogger().info(plugin + " loaded!");
        return true;
    }

    public static boolean loadPlugin(String name, Plugin plugin) {
        Dependency dependency;
        if (Dependencies.isLoaded(name) || Dependencies.isLoaded(plugin.getName())) {
            return true;
        }
        try {
            dependency = Dependency.valueOf(name);
            if (dependency.author != null && !plugin.getDescription().getAuthors().contains(dependency.author)) {
                ChestShop.getBukkitLogger().info("You are not using the supported variant of " + name + " by " + dependency.author + ". This variant of " + name + " seems to be made by " + (String)plugin.getDescription().getAuthors().get(0) + " which isn't supported!");
                return false;
            }
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
        Object listener = null;
        switch (dependency.ordinal()) {
            case 0: {
                listener = new LightweightChestProtection();
                break;
            }
            case 1: {
                listener = new Lockette();
                break;
            }
            case 2: {
                listener = new LockettePro();
                break;
            }
            case 3: {
                listener = new Deadbolt();
                break;
            }
            case 4: {
                listener = SimpleChestLock.getSimpleChestLock(plugin);
                break;
            }
            case 5: {
                listener = new BlockLocker();
                break;
            }
            case 6: {
                if (plugin.getDescription().getVersion().startsWith("2")) {
                    ChestShop.getBukkitLogger().severe("You are using an old version of Residence! Please update to the newest one, which supports UUIDs: http://ci.drtshock.net/job/Residence/");
                    break;
                }
                listener = new ResidenceChestProtection();
                break;
            }
            case 7: {
                boolean inUse;
                boolean bl = inUse = Properties.WORLDGUARD_USE_PROTECTION || Properties.WORLDGUARD_INTEGRATION;
                if (!inUse) {
                    return false;
                }
                if (Properties.WORLDGUARD_USE_PROTECTION) {
                    ChestShop.registerListener(new WorldGuardProtection(plugin));
                }
                if (!Properties.WORLDGUARD_INTEGRATION) break;
                listener = new WorldGuardBuilding(plugin);
                break;
            }
            case 8: {
                if (!Properties.GRIEFPREVENTION_INTEGRATION) {
                    return false;
                }
                listener = new GriefPrevenentionBuilding(plugin);
                break;
            }
            case 9: {
                if (!Properties.REDPROTECT_INTEGRATION) {
                    return false;
                }
                listener = new RedProtectBuilding(plugin);
                break;
            }
            case 10: {
                Heroes heroes = Heroes.getHeroes(plugin);
                if (heroes == null) {
                    return false;
                }
                listener = heroes;
                break;
            }
            case 11: {
                listener = new ItemBridge();
                break;
            }
            case 12: {
                MaterialUtil.Show.initialize(plugin);
            }
        }
        if (listener != null) {
            ChestShop.registerListener(listener);
        }
        PluginDescriptionFile description = plugin.getDescription();
        versions.put(description.getName(), description.getVersion());
        ChestShop.getBukkitLogger().info(description.getName() + " version " + description.getVersion() + " hooked.");
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEnable(PluginEnableEvent event) {
        Plugin plugin = event.getPlugin();
        try {
            Dependencies.loadPlugin(plugin.getName(), plugin);
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.WARNING, "Unable to hook into " + plugin.getName() + " " + plugin.getDescription().getVersion(), e);
        }
    }

    private static enum Dependency {
        LWC,
        Lockette("Acru"),
        LockettePro,
        Deadbolt,
        SimpleChestLock,
        BlockLocker,
        Residence,
        WorldGuard,
        GriefPrevention,
        RedProtect,
        Heroes,
        ItemBridge,
        ShowItem;

        private final String author;

        private Dependency() {
            this.author = null;
        }

        private Dependency(String author) {
            this.author = author;
        }
    }
}

