/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Database;

import com.Acrobot.Breeze.Utils.NameUtil;
import com.Acrobot.ChestShop.Database.DatabaseFileName;
import com.Acrobot.ChestShop.Libs.ORMlite.field.DataType;
import com.Acrobot.ChestShop.Libs.ORMlite.field.DatabaseField;
import com.Acrobot.ChestShop.Libs.ORMlite.table.DatabaseTable;
import java.util.Date;
import java.util.UUID;

@DatabaseTable(tableName="accounts")
@DatabaseFileName(value="users.db")
public class Account {
    @DatabaseField(index=true, canBeNull=false, uniqueCombo=true)
    private String name;
    @DatabaseField(id=true, index=true, canBeNull=false)
    private String shortName;
    @DatabaseField(index=true, canBeNull=false, uniqueCombo=true)
    private UUID uuid;
    @DatabaseField(canBeNull=false, dataType=DataType.DATE_LONG, defaultValue="0")
    private Date lastSeen;
    @DatabaseField(canBeNull=false, dataType=DataType.BOOLEAN, defaultValue="0")
    private boolean ignoreMessages;

    public Account() {
    }

    public Account(String name, UUID uuid) {
        this(name, NameUtil.stripUsername(name), uuid);
    }

    public Account(String name, String shortName, UUID uuid) {
        this.name = name;
        this.shortName = shortName;
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public Date getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(Date lastSeen) {
        this.lastSeen = lastSeen;
    }

    public boolean isIgnoringMessages() {
        return this.ignoreMessages;
    }

    public void setIgnoreMessages(boolean ignoreMessages) {
        this.ignoreMessages = ignoreMessages;
    }
}

