/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Containers;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class AdminInventory
implements Inventory {
    private ItemStack[] content;
    private int maxStackSize = 64;

    public AdminInventory(ItemStack[] content) {
        this.content = content;
    }

    public int getSize() {
        return Integer.MAX_VALUE;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void setMaxStackSize(int i) {
        this.maxStackSize = i;
    }

    public String getName() {
        return "Admin inventory";
    }

    public ItemStack getItem(int i) {
        if (this.content.length > i) {
            return this.content[i];
        }
        return null;
    }

    public void setItem(int i, ItemStack itemStack) {
        if (i > this.getSize()) {
            throw new IllegalArgumentException("Slot is outside inventory. Max size is " + this.getSize());
        }
        if (i >= this.content.length) {
            this.content = Arrays.copyOfRange(this.content, 0, i);
        }
        this.content[i] = itemStack;
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack ... itemStacks) {
        return new HashMap<Integer, ItemStack>();
    }

    public HashMap<Integer, ItemStack> removeItem(ItemStack ... itemStacks) {
        return new HashMap<Integer, ItemStack>();
    }

    public HashMap<Integer, ItemStack> removeItemAnySlot(ItemStack ... items) throws IllegalArgumentException {
        return new HashMap<Integer, ItemStack>();
    }

    public ItemStack[] getContents() {
        return this.content;
    }

    public void setContents(ItemStack[] itemStacks) {
        this.content = itemStacks;
    }

    public ItemStack[] getStorageContents() {
        return this.content;
    }

    public void setStorageContents(ItemStack[] itemStacks) throws IllegalArgumentException {
        this.content = itemStacks;
    }

    public boolean contains(Material material) {
        return this.first(material) > -1;
    }

    public boolean contains(ItemStack itemStack) {
        return this.first(itemStack) > -1;
    }

    public boolean contains(Material material, int i) {
        int amount = 0;
        for (ItemStack item : this.content) {
            if (item == null || item.getType() != material) continue;
            amount += item.getAmount();
        }
        return amount >= i;
    }

    public boolean contains(ItemStack itemStack, int i) {
        int amount = 0;
        for (ItemStack item : this.content) {
            if (!MaterialUtil.equals(item, itemStack)) continue;
            amount += itemStack.getAmount();
        }
        return amount >= i;
    }

    public boolean containsAtLeast(ItemStack itemStack, int i) {
        return this.contains(itemStack, i);
    }

    public HashMap<Integer, ? extends ItemStack> all(Material material) {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        if (material.getMaxDurability() != 0) {
            for (short currentDurability = 0; currentDurability < material.getMaxDurability(); currentDurability = (short)(currentDurability + 1)) {
                items.put(Integer.valueOf(currentDurability), new ItemStack(material, Integer.MAX_VALUE, currentDurability));
            }
            return items;
        }
        items.put(1, new ItemStack(material, Integer.MAX_VALUE));
        return items;
    }

    public HashMap<Integer, ? extends ItemStack> all(ItemStack itemStack) {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        if (itemStack != null) {
            ItemStack clone = itemStack.clone();
            clone.setAmount(Integer.MAX_VALUE);
            items.put(1, clone);
        }
        return items;
    }

    public int first(Material material) {
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null || this.content[i].getType() != material) continue;
            return i;
        }
        return -1;
    }

    public int first(ItemStack itemStack) {
        for (int i = 0; i < this.content.length; ++i) {
            if (!MaterialUtil.equals(this.content[i], itemStack)) continue;
            return i;
        }
        return -1;
    }

    public int firstEmpty() {
        return 0;
    }

    public boolean isEmpty() {
        return false;
    }

    public void remove(Material material) {
    }

    public void remove(ItemStack itemStack) {
    }

    public void clear(int i) {
    }

    public void clear() {
    }

    public int close() {
        return 0;
    }

    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>();
    }

    public String getTitle() {
        return "Admin inventory";
    }

    public InventoryType getType() {
        return null;
    }

    public InventoryHolder getHolder() {
        return null;
    }

    public InventoryHolder getHolder(boolean useSnapshot) {
        return null;
    }

    public ListIterator<ItemStack> iterator() {
        return Arrays.asList(this.content).listIterator();
    }

    public ListIterator<ItemStack> iterator(int i) {
        return Arrays.asList(this.content).listIterator(i);
    }

    public Location getLocation() {
        return null;
    }
}

