/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Commands;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Database.Account;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Toggle
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Account account;
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length != 0) {
            return false;
        }
        account.setIgnoreMessages(!(account = NameManager.getOrCreateAccount((OfflinePlayer)player)).isIgnoringMessages());
        if (account.isIgnoringMessages()) {
            Messages.TOGGLE_MESSAGES_OFF.sendWithPrefix((CommandSender)player, new String[0]);
        } else {
            Messages.TOGGLE_MESSAGES_ON.sendWithPrefix((CommandSender)player, new String[0]);
        }
        try {
            NameManager.storeAccount(account);
        }
        catch (Exception e) {
            ChestShop.getBukkitLogger().log(Level.WARNING, "Error while updating account " + account + ":", e);
            Messages.ERROR_OCCURRED.sendWithPrefix((CommandSender)player, "error", "Unable to store account data.");
        }
        return true;
    }

    public static boolean isIgnoring(OfflinePlayer player) {
        return player != null && NameManager.getOrCreateAccount(player).isIgnoringMessages();
    }

    public static boolean isIgnoring(UUID playerId) {
        Account account = NameManager.getAccount(playerId);
        return account != null && account.isIgnoringMessages();
    }

    @Deprecated
    public static boolean isIgnoring(String playerName) {
        return Toggle.isIgnoring(Bukkit.getOfflinePlayer((String)playerName));
    }
}

