/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Commands;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.ItemInfoEvent;
import com.Acrobot.ChestShop.Events.ItemParseEvent;
import com.Acrobot.ChestShop.Utils.ItemUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ItemInfo
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        ItemStack item;
        if (args.length == 0) {
            if (!(sender instanceof HumanEntity)) {
                return false;
            }
            item = ((HumanEntity)sender).getItemInHand();
        } else {
            ItemParseEvent parseEvent = new ItemParseEvent(StringUtil.joinArray(args));
            Bukkit.getPluginManager().callEvent((Event)parseEvent);
            item = parseEvent.getItem();
        }
        if (MaterialUtil.isEmpty(item)) {
            return false;
        }
        Messages.iteminfo.send(sender, new String[0]);
        if (!ItemInfo.sendItemName(sender, item, Messages.iteminfo_fullname)) {
            return true;
        }
        try {
            Messages.iteminfo_shopname.send(sender, "item", ItemUtil.getSignName(item));
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(ChatColor.RED + "Error while generating shop sign name. Please contact an admin or take a look at the console/log!");
            ChestShop.getPlugin().getLogger().log(Level.SEVERE, "Error while generating shop sign item name", e);
            return true;
        }
        ItemInfoEvent event = ChestShop.callEvent(new ItemInfoEvent(sender, item));
        for (Map.Entry<Messages.Message, String[]> entry : event.getMessages()) {
            entry.getKey().send(sender, entry.getValue());
        }
        return true;
    }

    public static boolean sendItemName(CommandSender sender, ItemStack item, Messages.Message message) {
        try {
            ImmutableMap replacementMap = ImmutableMap.of((Object)"item", (Object)ItemUtil.getName(item));
            if (!(Properties.SHOWITEM_MESSAGE && sender instanceof Player && MaterialUtil.Show.sendMessage((Player)sender, sender.getName(), message, false, new ItemStack[]{item}, (Map<String, String>)replacementMap, new String[0]))) {
                message.send(sender, (Map<String, String>)replacementMap);
            }
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(ChatColor.RED + "Error while generating full name. Please contact an admin or take a look at the console/log!");
            ChestShop.getPlugin().getLogger().log(Level.SEVERE, "Error while generating full item name", e);
            return false;
        }
        return true;
    }
}

