/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop;

import com.Acrobot.ChestShop.Commands.AccessToggle;
import com.Acrobot.ChestShop.Commands.Give;
import com.Acrobot.ChestShop.Commands.ItemInfo;
import com.Acrobot.ChestShop.Commands.Metrics;
import com.Acrobot.ChestShop.Commands.ShopInfo;
import com.Acrobot.ChestShop.Commands.Toggle;
import com.Acrobot.ChestShop.Commands.Version;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Database.Migrations;
import com.Acrobot.ChestShop.Dependencies;
import com.Acrobot.ChestShop.Libs.Kyori.adventure.platform.bukkit.BukkitAudiences;
import com.Acrobot.ChestShop.Libs.Kyori.adventure.text.Component;
import com.Acrobot.ChestShop.Libs.Kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.Acrobot.ChestShop.Listeners.AuthMeChestShopListener;
import com.Acrobot.ChestShop.Listeners.Block.BlockPlace;
import com.Acrobot.ChestShop.Listeners.Block.Break.ChestBreak;
import com.Acrobot.ChestShop.Listeners.Block.Break.SignBreak;
import com.Acrobot.ChestShop.Listeners.Block.SignCreate;
import com.Acrobot.ChestShop.Listeners.Economy.EconomyAdapter;
import com.Acrobot.ChestShop.Listeners.Economy.ServerAccountCorrector;
import com.Acrobot.ChestShop.Listeners.Economy.TaxModule;
import com.Acrobot.ChestShop.Listeners.GarbageTextListener;
import com.Acrobot.ChestShop.Listeners.Item.ItemMoveListener;
import com.Acrobot.ChestShop.Listeners.Item.ItemStringListener;
import com.Acrobot.ChestShop.Listeners.ItemInfoListener;
import com.Acrobot.ChestShop.Listeners.Modules.DiscountModule;
import com.Acrobot.ChestShop.Listeners.Modules.ItemAliasModule;
import com.Acrobot.ChestShop.Listeners.Modules.MetricsModule;
import com.Acrobot.ChestShop.Listeners.Modules.PriceRestrictionModule;
import com.Acrobot.ChestShop.Listeners.Modules.StockCounterModule;
import com.Acrobot.ChestShop.Listeners.Player.PlayerConnect;
import com.Acrobot.ChestShop.Listeners.Player.PlayerInteract;
import com.Acrobot.ChestShop.Listeners.Player.PlayerInventory;
import com.Acrobot.ChestShop.Listeners.Player.PlayerTeleport;
import com.Acrobot.ChestShop.Listeners.PostShopCreation.MessageSender;
import com.Acrobot.ChestShop.Listeners.PostShopCreation.ShopCreationLogger;
import com.Acrobot.ChestShop.Listeners.PostShopCreation.SignSticker;
import com.Acrobot.ChestShop.Listeners.PostTransaction.EconomicModule;
import com.Acrobot.ChestShop.Listeners.PostTransaction.EmptyShopDeleter;
import com.Acrobot.ChestShop.Listeners.PostTransaction.ItemManager;
import com.Acrobot.ChestShop.Listeners.PostTransaction.TransactionLogger;
import com.Acrobot.ChestShop.Listeners.PostTransaction.TransactionMessageSender;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.ChestChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.CreationFeeGetter;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.ItemChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.MoneyChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.NameChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.PermissionChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.PriceChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.PriceRatioChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.QuantityChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.TerrainChecker;
import com.Acrobot.ChestShop.Listeners.PreTransaction.AmountAndPriceChecker;
import com.Acrobot.ChestShop.Listeners.PreTransaction.CreativeModeIgnorer;
import com.Acrobot.ChestShop.Listeners.PreTransaction.ErrorMessageSender;
import com.Acrobot.ChestShop.Listeners.PreTransaction.InvalidNameIgnorer;
import com.Acrobot.ChestShop.Listeners.PreTransaction.PartialTransactionModule;
import com.Acrobot.ChestShop.Listeners.PreTransaction.PriceValidator;
import com.Acrobot.ChestShop.Listeners.PreTransaction.ShopValidator;
import com.Acrobot.ChestShop.Listeners.PreTransaction.SpamClickProtector;
import com.Acrobot.ChestShop.Listeners.PreTransaction.StockFittingChecker;
import com.Acrobot.ChestShop.Listeners.ShopInfoListener;
import com.Acrobot.ChestShop.Listeners.ShopRemoval.ShopRefundListener;
import com.Acrobot.ChestShop.Listeners.ShopRemoval.ShopRemovalLogger;
import com.Acrobot.ChestShop.Listeners.SignParseListener;
import com.Acrobot.ChestShop.Logging.FileFormatter;
import com.Acrobot.ChestShop.Metadata.ItemDatabase;
import com.Acrobot.ChestShop.Metrics.BStats.charts.AdvancedBarChart;
import com.Acrobot.ChestShop.Metrics.BStats.charts.DrilldownPie;
import com.Acrobot.ChestShop.Metrics.BStats.charts.MultiLineChart;
import com.Acrobot.ChestShop.Metrics.BStats.charts.SimpleBarChart;
import com.Acrobot.ChestShop.Metrics.BStats.charts.SimplePie;
import com.Acrobot.ChestShop.Metrics.BStats.charts.SingleLineChart;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.RestrictedSign;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import com.Acrobot.ChestShop.Updater.JenkinsBuildsNotifier;
import com.Acrobot.ChestShop.Updater.Updater;
import com.Acrobot.ChestShop.Utils.VersionAdapter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.logging.FileHandler;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestShop
extends JavaPlugin {
    private static ChestShop plugin;
    private static Server server;
    private static PluginDescriptionFile description;
    private static final ExecutorService executorService;
    private static com.Acrobot.ChestShop.Metrics.BStats.bukkit.Metrics bStats;
    private static BukkitAudiences audiences;
    private static File dataFolder;
    private static ItemDatabase itemDatabase;
    private static java.util.logging.Logger logger;
    private static java.util.logging.Logger shopLogger;
    private FileHandler handler;
    private List<PluginCommand> commands = new ArrayList<PluginCommand>();
    private static final int PROJECT_BUKKITDEV_ID = 31263;
    private static final String PROJECT_JENKINS_JOB_URL = "https://ci.minebench.de/job/ChestShop-3/";

    public ChestShop() {
        dataFolder = this.getDataFolder();
        logger = this.getLogger();
        shopLogger = java.util.logging.Logger.getLogger("ChestShop Shops");
        shopLogger.setParent(logger);
        description = this.getDescription();
        server = this.getServer();
        plugin = this;
    }

    public void onLoad() {
        Dependencies.initializePlugins();
    }

    public void onEnable() {
        bStats = new com.Acrobot.ChestShop.Metrics.BStats.bukkit.Metrics(this, 1109);
        audiences = BukkitAudiences.create((Plugin)this);
        this.turnOffDatabaseLogging();
        if (!this.handleMigrations()) {
            return;
        }
        this.registerCommand("iteminfo", new ItemInfo(), Permission.ITEMINFO);
        this.registerCommand("shopinfo", new ShopInfo(), Permission.SHOPINFO);
        this.registerCommand("csVersion", new Version(), Permission.ADMIN);
        this.registerCommand("csMetrics", new Metrics(), Permission.ADMIN);
        this.registerCommand("csGive", new Give(), Permission.ADMIN);
        this.registerCommand("cstoggle", new Toggle(), Permission.NOTIFY_TOGGLE);
        this.registerCommand("csaccess", new AccessToggle(), Permission.ACCESS_TOGGLE);
        this.loadConfig();
        itemDatabase = new ItemDatabase();
        if (!Dependencies.loadPlugins()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerEvents();
        this.registerVersionedAdapters();
        this.registerPluginMessagingChannels();
        this.startStatistics();
        this.startBuildNotificatier();
        this.startUpdater();
    }

    private void registerCommand(String name, CommandExecutor executor, Permission permission) {
        PluginCommand command = this.getCommand(name);
        if (command != null) {
            command.setExecutor(executor);
            command.setPermission(permission.toString());
            this.commands.add(command);
        }
    }

    public void loadConfig() {
        com.Acrobot.Breeze.Configuration.Configuration.pairFileAndClass(ChestShop.loadFile("config.yml"), Properties.class, ChestShop.getBukkitLogger());
        Messages.load();
        NameManager.load();
        this.commands.forEach(c -> c.setPermissionMessage(Messages.ACCESS_DENIED.getTextWithPrefix(null, new String[0])));
        if (this.handler != null) {
            shopLogger.removeHandler(this.handler);
        }
        if (Properties.LOG_TO_FILE) {
            if (this.handler == null) {
                File log = ChestShop.loadFile("ChestShop.log");
                this.handler = ChestShop.loadHandler(log.getAbsolutePath());
                this.handler.setFormatter(new FileFormatter());
            }
            shopLogger.addHandler(this.handler);
        }
        shopLogger.setUseParentHandlers(Properties.LOG_TO_CONSOLE);
    }

    private void turnOffDatabaseLogging() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.addFilter((Filter)new AbstractFilter(){

            public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
                return this.filter(logger.getName(), level);
            }

            public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
                return this.filter(logger.getName(), level);
            }

            public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
                return this.filter(logger.getName(), level);
            }

            public Filter.Result filter(LogEvent event) {
                return this.filter(event.getLoggerName(), event.getLevel());
            }

            private Filter.Result filter(String classname, Level level) {
                if (level.intLevel() <= Level.ERROR.intLevel() && !classname.contains("SqliteDatabaseType")) {
                    return Filter.Result.NEUTRAL;
                }
                if (classname.contains("SqliteDatabaseType") || classname.contains("TableUtils")) {
                    return Filter.Result.DENY;
                }
                return Filter.Result.NEUTRAL;
            }
        });
    }

    private boolean handleMigrations() {
        int lastVersion;
        int newVersion;
        File versionFile = ChestShop.loadFile("version");
        YamlConfiguration previousVersion = YamlConfiguration.loadConfiguration((File)versionFile);
        if (previousVersion.get("version") == null) {
            previousVersion.set("version", (Object)5);
            try {
                previousVersion.save(versionFile);
            }
            catch (IOException e) {
                this.getLogger().log(java.util.logging.Level.SEVERE, "Unable to save new database version 5", e);
            }
        }
        if ((newVersion = Migrations.migrate(lastVersion = previousVersion.getInt("version"))) == -1) {
            plugin.getLogger().log(java.util.logging.Level.SEVERE, "Error while migrating! ChestShop can not run with a broken/outdated database...");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        if (lastVersion != newVersion) {
            previousVersion.set("version", (Object)newVersion);
            try {
                previousVersion.save(versionFile);
            }
            catch (IOException e) {
                this.getLogger().log(java.util.logging.Level.SEVERE, "Unable to save new database version " + newVersion, e);
            }
        }
        return true;
    }

    public static File loadFile(String string) {
        File file = new File(dataFolder, string);
        return ChestShop.loadFile(file);
    }

    private static File loadFile(File file) {
        if (!file.exists()) {
            try {
                if (file.getParent() != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            catch (IOException e) {
                ChestShop.getBukkitLogger().log(java.util.logging.Level.SEVERE, "Unable to load file " + file.getName(), e);
            }
        }
        return file;
    }

    private static FileHandler loadHandler(String path) {
        FileHandler handler = null;
        try {
            handler = new FileHandler(path, true);
        }
        catch (IOException ex) {
            ChestShop.getBukkitLogger().log(java.util.logging.Level.SEVERE, "Unable to load handler " + path, ex);
        }
        return handler;
    }

    public void onDisable() {
        executorService.shutdown();
        try {
            executorService.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.handler != null) {
            this.handler.close();
            this.getLogger().removeHandler(this.handler);
        }
    }

    private void registerEvents() {
        this.registerEvent(new com.Acrobot.ChestShop.Plugins.ChestShop());
        this.registerEvent(new Dependencies());
        this.registerEvent(new NameManager());
        this.registerPreShopCreationEvents();
        this.registerPreTransactionEvents();
        this.registerPostShopCreationEvents();
        this.registerPostTransactionEvents();
        this.registerShopRemovalEvents();
        this.registerModules();
        this.registerEvent(new SignBreak());
        this.registerEvent(new SignCreate());
        this.registerEvent(new ChestBreak());
        this.registerEvent(new BlockPlace());
        this.registerEvent(new PlayerConnect());
        this.registerEvent(new PlayerInteract());
        this.registerEvent(new PlayerInventory());
        this.registerEvent(new PlayerTeleport());
        this.registerEvent(new SignParseListener());
        this.registerEvent(new ItemStringListener());
        this.registerEvent(new ItemInfoListener());
        this.registerEvent(new ShopInfoListener());
        this.registerEvent(new GarbageTextListener());
        Plugin authMe = this.getServer().getPluginManager().getPlugin("AuthMe");
        if (authMe != null && authMe.isEnabled()) {
            this.registerEvent(new AuthMeChestShopListener());
        }
        this.registerEvent(new RestrictedSign());
        if (!Properties.TURN_OFF_HOPPER_PROTECTION || Properties.USE_STOCK_COUNTER) {
            this.registerEvent(new ItemMoveListener());
        }
    }

    private void registerShopRemovalEvents() {
        this.registerEvent(new ShopRefundListener());
        this.registerEvent(new ShopRemovalLogger());
    }

    private void registerPreShopCreationEvents() {
        if (Properties.BLOCK_SHOPS_WITH_SELL_PRICE_HIGHER_THAN_BUY_PRICE) {
            this.registerEvent(new PriceRatioChecker());
        }
        this.registerEvent(new ChestChecker());
        this.registerEvent(new ItemChecker());
        this.registerEvent(new MoneyChecker());
        this.registerEvent(new NameChecker());
        this.registerEvent(new PermissionChecker());
        this.registerEvent(new com.Acrobot.ChestShop.Listeners.PreShopCreation.ErrorMessageSender());
        this.registerEvent(new PriceChecker());
        this.registerEvent(new QuantityChecker());
        this.registerEvent(new TerrainChecker());
    }

    private void registerPostShopCreationEvents() {
        this.registerEvent(new CreationFeeGetter());
        this.registerEvent(new MessageSender());
        this.registerEvent(new SignSticker());
        this.registerEvent(new ShopCreationLogger());
    }

    private void registerPreTransactionEvents() {
        if (Properties.ALLOW_PARTIAL_TRANSACTIONS) {
            this.registerEvent(new PartialTransactionModule());
        } else {
            this.registerEvent(new AmountAndPriceChecker());
        }
        this.registerEvent(new InvalidNameIgnorer());
        this.registerEvent(new CreativeModeIgnorer());
        this.registerEvent(new ErrorMessageSender());
        this.registerEvent(new com.Acrobot.ChestShop.Listeners.PreTransaction.PermissionChecker());
        this.registerEvent(new PriceValidator());
        this.registerEvent(new ShopValidator());
        this.registerEvent(new SpamClickProtector());
        this.registerEvent(new StockFittingChecker());
    }

    private void registerPostTransactionEvents() {
        this.registerEvent(new EconomicModule());
        this.registerEvent(new EmptyShopDeleter());
        this.registerEvent(new ItemManager());
        this.registerEvent(new TransactionLogger());
        this.registerEvent(new TransactionMessageSender());
    }

    private void registerModules() {
        this.registerEvent(new ItemAliasModule());
        this.registerEvent(new DiscountModule());
        this.registerEvent(new MetricsModule());
        this.registerEvent(new PriceRestrictionModule());
        this.registerEvent(new StockCounterModule());
        this.registerEconomicalModules();
    }

    private void registerEconomicalModules() {
        this.registerEvent(new ServerAccountCorrector());
        this.registerEvent(new TaxModule());
    }

    private void registerVersionedAdapters() {
        try (JarFile jarFile = new JarFile(this.getFile());){
            jarFile.stream().filter(entry -> !entry.isDirectory()).filter(entry -> entry.getName().startsWith("com/Acrobot/ChestShop/Adapter/") && entry.getName().endsWith(".class")).map(entry -> entry.getName().replace('/', '.').replace(".class", "")).forEach(className -> {
                try {
                    VersionAdapter adapterInstance;
                    Class<?> clazz = this.getClassLoader().loadClass((String)className);
                    if (VersionAdapter.class.isAssignableFrom(clazz) && (adapterInstance = (VersionAdapter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).isSupported()) {
                        if (adapterInstance instanceof Listener) {
                            this.registerEvent((Listener)adapterInstance);
                            ChestShop.logDebug("Registered listener for " + clazz.getSimpleName().replaceFirst("_", " ").replace('_', '.') + " features.");
                        } else {
                            ChestShop.logDebug("Found adapter for " + clazz.getSimpleName().replaceFirst("_", " ").replace('_', '.') + " features.");
                        }
                    }
                }
                catch (ReflectiveOperationException e) {
                    this.getLogger().log(java.util.logging.Level.WARNING, "Unable to register adapter " + className, e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void registerPluginMessagingChannels() {
        if (Properties.BUNGEECORD_MESSAGES) {
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        }
    }

    public void registerEvent(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    private void startStatistics() {
        try (JarFile jarFile2 = new JarFile(this.getFile());){
            String dist = jarFile2.getManifest().getMainAttributes().getValue("Distribution-Type");
            bStats.addCustomChart(new SimplePie("distributionType", () -> dist));
        }
        catch (IOException jarFile2) {
            // empty catch block
        }
        String serverVersion = this.getServer().getBukkitVersion().split("-")[0];
        bStats.addCustomChart(ChestShop.createStaticDrilldownStat("versionMcSelf", serverVersion, this.getDescription().getVersion()));
        bStats.addCustomChart(ChestShop.createStaticDrilldownStat("versionSelfMc", this.getDescription().getVersion(), serverVersion));
        bStats.addCustomChart(ChestShop.createStaticDrilldownStat("serverTypeVersionSelf", this.getServer().getName(), this.getDescription().getVersion()));
        bStats.addCustomChart(ChestShop.createStaticDrilldownStat("versionSelfServerType", this.getDescription().getVersion(), this.getServer().getName()));
        bStats.addCustomChart(ChestShop.createStaticDrilldownStat("versionMcServerType", serverVersion, this.getServer().getName()));
        bStats.addCustomChart(ChestShop.createStaticDrilldownStat("serverTypeVersionMc", this.getServer().getName(), serverVersion));
        String javaVersion = System.getProperty("java.version");
        bStats.addCustomChart(ChestShop.createStaticDrilldownStat("versionJavaSelf", javaVersion, this.getDescription().getVersion()));
        bStats.addCustomChart(ChestShop.createStaticDrilldownStat("versionSelfJava", this.getDescription().getVersion(), javaVersion));
        bStats.addCustomChart(ChestShop.createStaticDrilldownStat("versionJavaMc", javaVersion, serverVersion));
        bStats.addCustomChart(ChestShop.createStaticDrilldownStat("versionMcJava", serverVersion, javaVersion));
        bStats.addCustomChart(new SingleLineChart("shopAccounts", NameManager::getAccountCount));
        bStats.addCustomChart(new MultiLineChart("transactionCount", () -> ImmutableMap.of((Object)"total", (Object)MetricsModule.getTotalTransactions(), (Object)"buy", (Object)MetricsModule.getBuyTransactions(), (Object)"sell", (Object)MetricsModule.getSellTransactions())));
        bStats.addCustomChart(new MultiLineChart("itemCount", () -> ImmutableMap.of((Object)"total", (Object)MetricsModule.getTotalItemsCount(), (Object)"buy", (Object)MetricsModule.getSoldItemsCount(), (Object)"sell", (Object)MetricsModule.getBoughtItemsCount())));
        bStats.addCustomChart(new SimplePie("includeSettingsInMetrics", () -> Properties.INCLUDE_SETTINGS_IN_METRICS ? "enabled" : "disabled"));
        if (!Properties.INCLUDE_SETTINGS_IN_METRICS) {
            return;
        }
        bStats.addCustomChart(new SimplePie("ensure-correct-playerid", () -> Properties.ENSURE_CORRECT_PLAYERID ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("allow-sign-chest-open", () -> Properties.ALLOW_SIGN_CHEST_OPEN ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("uses-server-economy-account", () -> !Properties.SERVER_ECONOMY_ACCOUNT.isEmpty() ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("uses-server-economy-account-uuid", () -> !Properties.SERVER_ECONOMY_ACCOUNT_UUID.equals(new UUID(0L, 0L)) ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("allow-partial-transactions", () -> Properties.ALLOW_PARTIAL_TRANSACTIONS ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("bungeecord-messages", () -> Properties.BUNGEECORD_MESSAGES ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("allow-multiple-shops-at-one-block", () -> Properties.ALLOW_MULTIPLE_SHOPS_AT_ONE_BLOCK ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("allow-partial-transactions", () -> Properties.ALLOW_PARTIAL_TRANSACTIONS ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("log-to-console", () -> Properties.LOG_TO_CONSOLE ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("log-to-file", () -> Properties.LOG_TO_FILE ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("auto-update", () -> !Properties.TURN_OFF_UPDATES ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("release-notifications", () -> !Properties.TURN_OFF_UPDATE_NOTIFIER ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("dev-build-notifications", () -> !Properties.TURN_OFF_DEV_UPDATE_NOTIFIER ? "enabled" : "disabled"));
        bStats.addCustomChart(new AdvancedBarChart("pluginProperties", () -> {
            LinkedHashMap<String, int[]> map = new LinkedHashMap<String, int[]>();
            map.put("ensure-correct-playerid", this.getChartArray(Properties.ENSURE_CORRECT_PLAYERID));
            map.put("reverse-buttons", this.getChartArray(Properties.REVERSE_BUTTONS));
            map.put("shift-sells-in-stacks", this.getChartArray(Properties.SHIFT_SELLS_IN_STACKS));
            map.put("shift-sells-everything", this.getChartArray(Properties.SHIFT_SELLS_EVERYTHING));
            map.put("allow-sign-chest-open", this.getChartArray(!Properties.ALLOW_SIGN_CHEST_OPEN));
            map.put("sign-dying", this.getChartArray(!Properties.SIGN_DYING));
            map.put("remove-empty-shops", this.getChartArray(!Properties.REMOVE_EMPTY_SHOPS));
            map.put("remove-empty-chests", this.getChartArray(!Properties.REMOVE_EMPTY_CHESTS));
            map.put("uses-server-economy-account", this.getChartArray(!Properties.SERVER_ECONOMY_ACCOUNT.isEmpty()));
            map.put("uses-server-economy-account-uuid", this.getChartArray(!Properties.SERVER_ECONOMY_ACCOUNT_UUID.equals(new UUID(0L, 0L))));
            map.put("allow-multiple-shops-at-one-block", this.getChartArray(Properties.ALLOW_MULTIPLE_SHOPS_AT_ONE_BLOCK));
            map.put("allow-partial-transactions", this.getChartArray(Properties.ALLOW_PARTIAL_TRANSACTIONS));
            map.put("bungeecord-messages", this.getChartArray(Properties.BUNGEECORD_MESSAGES));
            map.put("log-to-console", this.getChartArray(Properties.LOG_TO_CONSOLE));
            map.put("log-to-file", this.getChartArray(Properties.LOG_TO_FILE));
            map.put("auto-update", this.getChartArray(!Properties.TURN_OFF_UPDATES));
            map.put("release-notifications", this.getChartArray(!Properties.TURN_OFF_UPDATE_NOTIFIER));
            map.put("dev-build-notifications", this.getChartArray(!Properties.TURN_OFF_DEV_UPDATE_NOTIFIER));
            return map;
        }));
        bStats.addCustomChart(new SimpleBarChart("shopContainers", () -> Properties.SHOP_CONTAINERS.stream().map(Enum::name).collect(Collectors.toMap(k -> k, k -> 1))));
    }

    public static DrilldownPie createStaticDrilldownStat(String statId, String value1, String value2) {
        ImmutableMap map = ImmutableMap.of((Object)value1, (Object)ImmutableMap.of((Object)value2, (Object)1));
        return new DrilldownPie(statId, () -> ChestShop.lambda$createStaticDrilldownStat$26((Map)map));
    }

    public static DrilldownPie createStaticDrilldownStat(String statId, Callable<EconomyAdapter.ProviderInfo> callableProviderInfo) {
        return new DrilldownPie(statId, () -> {
            EconomyAdapter.ProviderInfo providerInfo = (EconomyAdapter.ProviderInfo)callableProviderInfo.call();
            if (providerInfo == null) {
                return ImmutableMap.of();
            }
            return ImmutableMap.of((Object)providerInfo.getName(), (Object)ImmutableMap.of((Object)providerInfo.getVersion(), (Object)1));
        });
    }

    private int[] getChartArray(boolean value) {
        return new int[]{!value ? 1 : 0, value ? 0 : 1};
    }

    private void startUpdater() {
        if (Properties.TURN_OFF_UPDATES) {
            this.getLogger().info("Auto-updater is disabled. If you want the plugin to automatically download new releases then set 'TURN_OFF_UPDATES' to 'false' in your config.yml!");
            if (!Properties.TURN_OFF_UPDATE_NOTIFIER) {
                Updater updater = new Updater((Plugin)this, ChestShop.getPluginName().toLowerCase(Locale.ROOT), this.getFile(), Updater.UpdateType.NO_DOWNLOAD, true);
                ChestShop.runInAsyncThread(() -> {
                    if (updater.getResult() == Updater.UpdateResult.UPDATE_AVAILABLE) {
                        this.getLogger().info("There is a new version available: " + updater.getLatestName() + ". You can download it from https://modrinth.com/plugin/" + ChestShop.getPluginName().toLowerCase(Locale.ROOT));
                    }
                });
            }
            return;
        }
        new Updater((Plugin)this, ChestShop.getPluginName().toLowerCase(Locale.ROOT), this.getFile(), Updater.UpdateType.DEFAULT, true);
    }

    private void startBuildNotificatier() {
        if (Properties.TURN_OFF_DEV_UPDATE_NOTIFIER) {
            return;
        }
        new JenkinsBuildsNotifier((Plugin)this, PROJECT_JENKINS_JOB_URL);
    }

    public static ItemDatabase getItemDatabase() {
        return itemDatabase;
    }

    public static File getFolder() {
        return dataFolder;
    }

    public static java.util.logging.Logger getShopLogger() {
        return shopLogger;
    }

    public static java.util.logging.Logger getBukkitLogger() {
        return logger;
    }

    public static void logDebug(String message) {
        if (Properties.DEBUG) {
            ChestShop.getBukkitLogger().info("[DEBUG] " + message);
        }
    }

    public static Server getBukkitServer() {
        return server;
    }

    public static String getVersion() {
        return description.getVersion();
    }

    public static String getPluginName() {
        return description.getName();
    }

    public static List<String> getDependencies() {
        return description.getSoftDepend();
    }

    public static ChestShop getPlugin() {
        return plugin;
    }

    public static com.Acrobot.ChestShop.Metrics.BStats.bukkit.Metrics getMetrics() {
        return bStats;
    }

    public static BukkitAudiences getAudiences() {
        return audiences;
    }

    public static void registerListener(Listener listener) {
        plugin.registerEvent(listener);
    }

    public static <E extends Event> E callEvent(E event) {
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static void sendBungeeMessage(String playerName, Messages.Message message, Map<String, String> replacementMap, String ... replacements) {
        ChestShop.sendBungeeMessage(playerName, message.getComponent(null, true, replacementMap, replacements));
    }

    public static void sendBungeeMessage(String playerName, String message) {
        ChestShop.sendBungeeMessage(playerName, "Message", message);
    }

    public static void sendBungeeMessage(String playerName, BaseComponent[] message) {
        ChestShop.sendBungeeMessage(playerName, "MessageRaw", ComponentSerializer.toString((BaseComponent[])message));
    }

    public static void sendBungeeMessage(String playerName, Component message) {
        ChestShop.sendBungeeMessage(playerName, "MessageRaw", (String)GsonComponentSerializer.gson().serialize(message));
    }

    private static void sendBungeeMessage(String playerName, String channel, String message) {
        if (Properties.BUNGEECORD_MESSAGES && !Bukkit.getOnlinePlayers().isEmpty()) {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(channel);
            out.writeUTF(playerName);
            out.writeUTF(message);
            ((Player)Bukkit.getOnlinePlayers().iterator().next()).sendPluginMessage((Plugin)plugin, "BungeeCord", out.toByteArray());
        }
    }

    public static void runInAsyncThread(Runnable runnable) {
        executorService.submit(runnable);
    }

    private static /* synthetic */ Map lambda$createStaticDrilldownStat$26(Map map) throws Exception {
        return map;
    }

    static {
        executorService = Executors.newCachedThreadPool();
    }
}

