/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;

public class StringUtil {
    private static String characters = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~\u00a6\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0083\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb";
    private static int[] extraWidth = new int[]{4, 2, 5, 6, 6, 6, 6, 3, 5, 5, 5, 6, 2, 6, 2, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 2, 2, 5, 6, 5, 6, 7, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 4, 6, 6, 3, 6, 6, 6, 6, 6, 5, 6, 6, 2, 6, 5, 3, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6, 6, 6, 5, 2, 5, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 3, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 3, 6, 6, 6, 6, 6, 6, 6, 7, 6, 6, 6, 2, 6, 6, 8, 9, 9, 6, 6, 6, 8, 8, 6, 8, 8, 8, 8, 8, 6, 6, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 6, 9, 9, 9, 5, 9, 9, 8, 7, 7, 8, 7, 8, 8, 8, 7, 8, 8, 7, 9, 9, 6, 7, 7, 7, 7, 7, 9, 6, 7, 8, 7, 6, 6, 9, 7, 6, 7, 1};

    public static String capitalizeFirstLetter(String string, char separator) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String[] words = string.toLowerCase(Locale.ROOT).split(String.valueOf(separator));
        return Arrays.stream(words).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1)).collect(Collectors.joining(" "));
    }

    public static String capitalizeFirstLetter(String string) {
        return StringUtil.capitalizeFirstLetter(string, ' ');
    }

    public static String joinArray(String[] array) {
        return String.join((CharSequence)" ", array);
    }

    public static String joinArray(Collection<String> array) {
        return String.join((CharSequence)" ", array);
    }

    public static String stripColourCodes(String string) {
        return ChatColor.stripColor((String)string);
    }

    public static String[] stripColourCodes(String[] strings) {
        String[] output = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            output[i] = StringUtil.stripColourCodes(strings[i]);
        }
        return output;
    }

    public static int getMinecraftCharWidth(char c) {
        if (c != '\u00a7') {
            int index = characters.indexOf(c);
            if (index > -1) {
                return extraWidth[index];
            }
            return 10;
        }
        return 0;
    }

    public static int getMinecraftStringWidth(String string) {
        int width = 0;
        for (char c : string.toCharArray()) {
            width += StringUtil.getMinecraftCharWidth(c);
        }
        return width;
    }

    public static String strip(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stripped = new StringBuilder();
        StringBuilder cachedWhitespace = new StringBuilder();
        for (int codePoint : string.codePoints().toArray()) {
            if (!Character.isWhitespace(codePoint)) {
                if (cachedWhitespace.length() > 0) {
                    stripped.append((CharSequence)cachedWhitespace);
                    cachedWhitespace = new StringBuilder();
                }
                stripped.appendCodePoint(codePoint);
                continue;
            }
            if (stripped.length() <= 0) continue;
            cachedWhitespace.appendCodePoint(codePoint);
        }
        return stripped.toString();
    }

    public static Map<String, String> map(String ... values) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int i = 0;
        while (i + 1 < values.length) {
            map.put(values[i], values[i + 1]);
            i += 2;
        }
        return map;
    }
}

