/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;

public class PriceUtil {
    public static final BigDecimal NO_PRICE = BigDecimal.valueOf(-1L);
    public static final BigDecimal FREE = BigDecimal.valueOf(0L);
    public static final BigDecimal MAX = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final String FREE_TEXT = "free";
    public static final char BUY_INDICATOR = 'b';
    public static final char SELL_INDICATOR = 's';
    private static final Map<Character, BigDecimal> MULTIPLIERS = ImmutableMap.of((Object)Character.valueOf('k'), (Object)new BigDecimal(1000), (Object)Character.valueOf('m'), (Object)new BigDecimal(1000000));

    public static BigDecimal getExact(String text, char indicator) {
        String[] split = text.replace(" ", "").toLowerCase(Locale.ROOT).split(":");
        String character = String.valueOf(indicator).toLowerCase(Locale.ROOT);
        for (String part : split) {
            if (!part.startsWith(character) && !part.endsWith(character)) continue;
            if ((part = part.replace(character, "")).equals(FREE_TEXT)) {
                return FREE;
            }
            try {
                BigDecimal price = PriceUtil.parseMultipliedPrice(part);
                if (PriceUtil.isValidPrice(price)) {
                    return price;
                }
                return NO_PRICE;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return NO_PRICE;
    }

    private static BigDecimal parseMultipliedPrice(String part) throws NumberFormatException {
        for (Map.Entry<Character, BigDecimal> entry : MULTIPLIERS.entrySet()) {
            String suffix = entry.getKey().toString();
            if (!part.endsWith(suffix)) continue;
            String priceString = part.substring(0, part.length() - suffix.length());
            BigDecimal number = new BigDecimal(priceString);
            BigDecimal multiplier = entry.getValue();
            return number.multiply(multiplier);
        }
        return new BigDecimal(part);
    }

    public static boolean hasSingleMultiplier(String part) {
        boolean foundMultiplier = false;
        part = part.toLowerCase(Locale.ROOT);
        for (Character c : MULTIPLIERS.keySet()) {
            if (!part.contains(c.toString())) continue;
            if (foundMultiplier) {
                return false;
            }
            foundMultiplier = true;
        }
        return true;
    }

    @Deprecated
    public static double get(String text, char indicator) {
        return PriceUtil.getExact(text, indicator).doubleValue();
    }

    public static BigDecimal getExactBuyPrice(String text) {
        return PriceUtil.getExact(text, 'b');
    }

    public static BigDecimal getExactSellPrice(String text) {
        return PriceUtil.getExact(text, 's');
    }

    @Deprecated
    public static double getBuyPrice(String text) {
        return PriceUtil.getExactBuyPrice(text).doubleValue();
    }

    @Deprecated
    public static double getSellPrice(String text) {
        return PriceUtil.getExactSellPrice(text).doubleValue();
    }

    public static boolean hasBuyPrice(String text) {
        return PriceUtil.hasPrice(text, 'b');
    }

    public static boolean hasSellPrice(String text) {
        return PriceUtil.hasPrice(text, 's');
    }

    public static boolean hasPrice(String text, char indicator) {
        return PriceUtil.getExact(text, indicator).compareTo(NO_PRICE) != 0;
    }

    public static boolean isPrice(String text) {
        if ((text = text.trim().toLowerCase(Locale.ROOT)).equals(FREE_TEXT)) {
            return true;
        }
        try {
            return PriceUtil.isValidPrice(PriceUtil.parseMultipliedPrice(text));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isValidPrice(BigDecimal price) {
        return price.compareTo(BigDecimal.ZERO) >= 0 && price.compareTo(MAX) <= 0;
    }
}

