/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.MojangAPI.NameFetcher;
import com.Acrobot.Breeze.Utils.MojangAPI.UUIDFetcher;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class NameUtil {
    private static final UUID INVALID_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public static UUID getUUID(Player player) {
        return player.getUniqueId();
    }

    public static UUID getUUID(String username) {
        UUIDFetcher fetcher = new UUIDFetcher(username);
        try {
            Object uuidMap = fetcher.call();
            if (uuidMap.size() < 1) {
                return INVALID_UUID;
            }
            return (UUID)uuidMap.get(username);
        }
        catch (Exception exception) {
            return INVALID_UUID;
        }
    }

    public static Map<String, UUID> getUUID(String ... usernames) {
        UUIDFetcher fetcher = new UUIDFetcher(usernames);
        try {
            return fetcher.call();
        }
        catch (Exception exception) {
            return new HashMap<String, UUID>();
        }
    }

    public static String getName(UUID uuid) {
        NameFetcher fetcher = new NameFetcher(uuid);
        try {
            Object uuidMap = fetcher.call();
            return (String)uuidMap.get(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<UUID, String> getName(UUID ... uuids) {
        NameFetcher fetcher = new NameFetcher(uuids);
        try {
            return fetcher.call();
        }
        catch (Exception e) {
            return new HashMap<UUID, String>();
        }
    }

    public static boolean isInvalid(UUID uuid) {
        return uuid.equals(INVALID_UUID);
    }

    public static String stripUsername(String username) {
        return NameUtil.stripUsername(username, 15);
    }

    public static String stripUsername(String username, int length) {
        if (username.length() > length) {
            return username.substring(0, length);
        }
        return username;
    }
}

