/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils.MojangAPI;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class NameFetcher
implements Callable<Map<UUID, String>> {
    private static final String PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private final JSONParser jsonParser = new JSONParser();
    private final List<UUID> uuids;

    public NameFetcher(UUID ... uuids) {
        this.uuids = Arrays.asList(uuids);
    }

    @Override
    public Map<UUID, String> call() throws Exception {
        HashMap<UUID, String> uuidStringMap = new HashMap<UUID, String>();
        for (UUID uuid : this.uuids) {
            HttpURLConnection connection = (HttpURLConnection)new URL(PROFILE_URL + uuid.toString().replace("-", "")).openConnection();
            JSONObject response = (JSONObject)this.jsonParser.parse((Reader)new InputStreamReader(connection.getInputStream()));
            String name = (String)response.get((Object)"name");
            if (name == null) continue;
            String cause = (String)response.get((Object)"cause");
            String errorMessage = (String)response.get((Object)"errorMessage");
            if (cause != null && !cause.isEmpty()) {
                throw new IllegalStateException(errorMessage);
            }
            uuidStringMap.put(uuid, name);
        }
        return uuidStringMap;
    }
}

