/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Collection.SimpleCache;
import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.MaterialParseEvent;
import com.Acrobot.ChestShop.Libs.Kyori.adventure.text.Component;
import com.Acrobot.ChestShop.Libs.Kyori.adventure.text.TextComponent;
import com.Acrobot.ChestShop.Libs.Kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.Acrobot.ChestShop.Libs.MineDown.Replacer;
import de.themoep.ShowItem.api.ShowItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.VisibleForTesting;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class MaterialUtil {
    public static final Pattern DURABILITY = Pattern.compile(":\\d+");
    public static final Pattern METADATA = Pattern.compile("#[0-9a-zA-Z]+");
    @Deprecated
    public static final boolean LONG_NAME = true;
    @Deprecated
    public static final boolean SHORT_NAME = false;
    @Deprecated
    public static final short MAXIMUM_SIGN_LETTERS = 15;
    public static final int MAXIMUM_SIGN_WIDTH = (short)StringUtil.getMinecraftStringWidth("---------------");
    private static final Map<String, String> ABBREVIATIONS = StringUtil.map("Egg", "Eg", "Spawn", "Spaw", "Pottery", "Pot", "Heartbreak", "Heartbr", "Sherd", "Sher");
    private static final Map<String, String> UNIDIRECTIONAL_ABBREVIATIONS = StringUtil.map("Endermite", "Endmite", "Endmite", "Endmit", "Wayfinder", "Wayfndr", "Wayfndr", "Wf", "Heartbr", "Hrtbr", "Hrtbr", "Hrtb");
    private static final SimpleCache<String, Material> MATERIAL_CACHE = new SimpleCache(Properties.CACHE_SIZE);
    private static final Yaml YAML = new Yaml((BaseConstructor)new YamlBukkitConstructor(), (Representer)new YamlRepresenter(), new DumperOptions());

    public static boolean isEmpty(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    public static boolean equals(ItemStack one, ItemStack two) {
        Map twoSerMeta;
        ItemMeta twoMeta;
        if (one == null || two == null) {
            return one == two;
        }
        if (one.isSimilar(two)) {
            return true;
        }
        if (one.getType() != two.getType() || one.getDurability() != two.getDurability() || one.hasItemMeta() && two.hasItemMeta() && one.getItemMeta().getClass() != two.getItemMeta().getClass()) {
            return false;
        }
        if (!one.hasItemMeta() && !two.hasItemMeta()) {
            return true;
        }
        ItemMeta oneMeta = one.getItemMeta();
        if (oneMeta == (twoMeta = two.getItemMeta()) || oneMeta == null || twoMeta == null) {
            return oneMeta == twoMeta;
        }
        Map oneSerMeta = oneMeta.serialize();
        if (oneSerMeta.equals(twoSerMeta = twoMeta.serialize())) {
            return true;
        }
        ItemStack oneCloned = one.clone();
        oneCloned.setAmount(1);
        ItemStack twoCloned = two.clone();
        twoCloned.setAmount(1);
        ItemStack oneDumped = (ItemStack)YAML.loadAs(YAML.dump((Object)oneCloned), ItemStack.class);
        if (oneDumped.isSimilar(twoCloned)) {
            return true;
        }
        ItemMeta oneDumpedMeta = oneDumped.getItemMeta();
        if (oneDumpedMeta != null && oneDumpedMeta.serialize().equals(twoSerMeta)) {
            return true;
        }
        ItemStack twoDumped = (ItemStack)YAML.loadAs(YAML.dump((Object)twoCloned), ItemStack.class);
        if (oneDumped.isSimilar(twoDumped)) {
            return true;
        }
        ItemMeta twoDumpedMeta = twoDumped.getItemMeta();
        if (oneDumpedMeta != null && twoDumpedMeta != null && oneDumpedMeta.serialize().equals(twoDumpedMeta.serialize())) {
            return true;
        }
        return oneDumpedMeta == twoDumpedMeta;
    }

    public static Material getMaterial(String name) {
        String replacedName = name;
        ArrayList<Map.Entry<String, String>> abbreviations = new ArrayList<Map.Entry<String, String>>(UNIDIRECTIONAL_ABBREVIATIONS.entrySet());
        for (int i = abbreviations.size() - 1; i >= 0; --i) {
            Map.Entry entry = (Map.Entry)abbreviations.get(i);
            replacedName = replacedName.replaceAll((String)entry.getValue() + "(_|$)?", (String)entry.getKey() + "$1");
        }
        String formatted = name.replaceAll("(?<!^)(?>\\s?)([A-Z1-9])", "_$1").replace(' ', '_').toUpperCase(Locale.ROOT);
        Material material = MATERIAL_CACHE.get(formatted);
        if (material != null) {
            return material;
        }
        material = Material.matchMaterial((String)name);
        if (material != null) {
            MATERIAL_CACHE.put(formatted, material);
            return material;
        }
        material = (Material)new EnumParser().parse(replacedName, (Enum[])Material.values());
        if (material != null) {
            MATERIAL_CACHE.put(formatted, material);
        }
        return material;
    }

    @Deprecated
    public static String getItemList(ItemStack[] items) {
        Map<ItemStack, Integer> itemCounts = InventoryUtil.getItemCounts(items);
        ArrayList<String> itemText = new ArrayList<String>();
        for (Map.Entry<ItemStack, Integer> entry : itemCounts.entrySet()) {
            itemText.add(entry.getValue() + " " + MaterialUtil.getName(entry.getKey()));
        }
        return String.join((CharSequence)", ", itemText);
    }

    public static String getName(ItemStack itemStack) {
        return MaterialUtil.getName(itemStack, 0);
    }

    @Deprecated
    public static String getName(ItemStack itemStack, boolean showDataValue) {
        return MaterialUtil.getName(itemStack, 0);
    }

    public static String getSignName(ItemStack itemStack) {
        return MaterialUtil.getName(itemStack, MAXIMUM_SIGN_WIDTH);
    }

    public static String getName(ItemStack itemStack, int maxWidth) {
        int codeWidth;
        Damageable damageable;
        String itemName = itemStack.getType().toString();
        String durability = "";
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage()) {
            durability = ":" + damageable.getDamage();
        }
        String metaData = "";
        if (MaterialUtil.hasCustomData(itemStack)) {
            metaData = "#" + Metadata.getItemCode(itemStack);
        }
        String code = StringUtil.capitalizeFirstLetter(itemName, '_');
        if (maxWidth > 0 && (codeWidth = StringUtil.getMinecraftStringWidth(code + durability + metaData)) > maxWidth) {
            int exceeding = codeWidth - maxWidth;
            code = MaterialUtil.getShortenedName(code, StringUtil.getMinecraftStringWidth(code) - exceeding);
        }
        return code + durability + metaData;
    }

    private static boolean hasCustomData(ItemStack itemStack) {
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Damageable && !((Damageable)itemMeta).hasDamage()) {
            return true;
        }
        Map data = itemMeta.serialize();
        return data.size() > 2;
    }

    public static String getShortenedName(String itemName, int maxWidth) {
        int i;
        int remove;
        int endWidth;
        String name = itemName.replaceAll("([a-z])([A-Z1-9])", "$1 $2");
        int width = StringUtil.getMinecraftStringWidth(name = StringUtil.capitalizeFirstLetter(name.replace('_', ' '), ' '));
        if (width <= maxWidth) {
            return name;
        }
        CharSequence[] itemParts = name.split("[ \\-]");
        String noSpaceName = String.join((CharSequence)"", itemParts);
        width = StringUtil.getMinecraftStringWidth(noSpaceName);
        if (width <= maxWidth) {
            return noSpaceName;
        }
        for (Map.Entry<String, String> entry : ABBREVIATIONS.entrySet()) {
            itemParts = (name = name.replaceAll(entry.getKey() + "( |$)", entry.getValue() + "$1")).split("[ \\-]");
            noSpaceName = String.join((CharSequence)"", itemParts);
            width = StringUtil.getMinecraftStringWidth(noSpaceName);
            if (width > maxWidth) continue;
            return noSpaceName;
        }
        for (Map.Entry<String, String> entry : UNIDIRECTIONAL_ABBREVIATIONS.entrySet()) {
            itemParts = (name = name.replaceAll(entry.getKey() + "( |$)", entry.getValue() + "$1")).split("[ \\-]");
            noSpaceName = String.join((CharSequence)"", itemParts);
            width = StringUtil.getMinecraftStringWidth(noSpaceName);
            if (width > maxWidth) continue;
            return noSpaceName;
        }
        int exceeding = width - maxWidth;
        int shortestIndex = 0;
        int longestIndex = 0;
        for (int i2 = 0; i2 < itemParts.length; ++i2) {
            if (StringUtil.getMinecraftStringWidth((String)itemParts[longestIndex]) < StringUtil.getMinecraftStringWidth((String)itemParts[i2])) {
                longestIndex = i2;
            }
            if (StringUtil.getMinecraftStringWidth((String)itemParts[shortestIndex]) <= StringUtil.getMinecraftStringWidth((String)itemParts[i2])) continue;
            shortestIndex = i2;
        }
        int shortestWidth = StringUtil.getMinecraftStringWidth((String)itemParts[shortestIndex]);
        int longestWidth = StringUtil.getMinecraftStringWidth((String)itemParts[longestIndex]);
        for (remove = longestWidth - shortestWidth; remove > 0 && exceeding > 0; remove -= endWidth, exceeding -= endWidth) {
            endWidth = StringUtil.getMinecraftCharWidth(((String)itemParts[longestIndex]).charAt(((String)itemParts[longestIndex]).length() - 1));
            itemParts[longestIndex] = ((String)itemParts[longestIndex]).substring(0, ((String)itemParts[longestIndex]).length() - 1);
        }
        for (i = itemParts.length - 1; i >= 0 && exceeding > 0; --i) {
            int partWidth = StringUtil.getMinecraftStringWidth((String)itemParts[i]);
            if (partWidth > shortestWidth) {
                remove = partWidth - shortestWidth;
            }
            if (remove > exceeding) {
                remove = exceeding;
            }
            while (remove > 0) {
                int endWidth2 = StringUtil.getMinecraftCharWidth(((String)itemParts[i]).charAt(((String)itemParts[i]).length() - 1));
                itemParts[i] = ((String)itemParts[i]).substring(0, ((String)itemParts[i]).length() - 1);
                remove -= endWidth2;
                exceeding -= endWidth2;
            }
        }
        while (exceeding > 0) {
            int endWidth3;
            for (i = itemParts.length - 1; i >= 0 && exceeding > 0; exceeding -= endWidth3, --i) {
                endWidth3 = StringUtil.getMinecraftCharWidth(((String)itemParts[i]).charAt(((String)itemParts[i]).length() - 1));
                itemParts[i] = ((String)itemParts[i]).substring(0, ((String)itemParts[i]).length() - 1);
            }
        }
        return String.join((CharSequence)"", itemParts);
    }

    public static ItemStack getItem(String itemName) {
        String[] split = itemName.split("[:#]");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
        }
        Integer durability = MaterialUtil.getDurability(itemName);
        MaterialParseEvent parseEvent = new MaterialParseEvent(split[0], durability != null ? durability.shortValue() : (short)0);
        Bukkit.getPluginManager().callEvent((Event)parseEvent);
        Material material = parseEvent.getMaterial();
        if (material == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(material);
        ItemMeta meta = MaterialUtil.getMetadata(itemName);
        if (durability != null) {
            if (meta == null) {
                meta = itemStack.getItemMeta();
            }
            if (meta instanceof Damageable) {
                ((Damageable)meta).setDamage(durability.intValue());
            }
        }
        if (meta != null) {
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    public static Integer getDurability(String itemName) {
        Matcher m = DURABILITY.matcher(itemName);
        if (!m.find()) {
            return null;
        }
        String data = m.group();
        if (data == null || data.isEmpty()) {
            return null;
        }
        data = data.substring(1);
        try {
            return Integer.parseInt(data);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @VisibleForTesting
    static String parseMetadata(String itemName) {
        Matcher m = METADATA.matcher(itemName);
        if (!m.find()) {
            return null;
        }
        return m.group().substring(1);
    }

    public static ItemMeta getMetadata(String itemName) {
        String group = MaterialUtil.parseMetadata(itemName);
        return group != null ? Metadata.getFromCode(group) : null;
    }

    private static class EnumParser<E extends Enum<E>> {
        private EnumParser() {
        }

        private E parse(String name, E[] values) {
            String formatted = name.replaceAll("(?<!^)(?>\\s?)([A-Z1-9])", "_$1").toUpperCase(Locale.ROOT).replace(' ', '_');
            try {
                return Enum.valueOf(((Enum)values[0]).getDeclaringClass(), formatted);
            }
            catch (IllegalArgumentException exception) {
                ArrayList<E> possibleEnums = new ArrayList<E>();
                String[] typeParts = formatted.split("_");
                int length = Short.MAX_VALUE;
                for (E e : values) {
                    String[] nameParts;
                    String enumName = ((Enum)e).name();
                    if (enumName.length() < length && enumName.startsWith(formatted)) {
                        length = enumName.length();
                        possibleEnums.add(e);
                        continue;
                    }
                    if (typeParts.length <= 1 || typeParts.length != (nameParts = enumName.split("_")).length) continue;
                    boolean matched = true;
                    for (int i = 0; i < nameParts.length; ++i) {
                        if (nameParts[i].startsWith(typeParts[i])) continue;
                        matched = false;
                        break;
                    }
                    if (!matched) continue;
                    possibleEnums.add(e);
                }
                if (possibleEnums.size() == 1) {
                    return (E)((Enum)possibleEnums.get(0));
                }
                if (possibleEnums.size() > 1) {
                    int formattedLength = formatted.length();
                    int closestDeviation = Short.MAX_VALUE;
                    Enum closestEnum = null;
                    for (Enum possibleEnum : possibleEnums) {
                        int deviation = possibleEnum.name().length() - formattedLength;
                        if (deviation >= closestDeviation) continue;
                        closestDeviation = deviation;
                        closestEnum = possibleEnum;
                    }
                    return (E)closestEnum;
                }
                return null;
            }
        }
    }

    public static class Metadata {
        public static ItemMeta getFromCode(String code) {
            ItemStack item = ChestShop.getItemDatabase().getFromCode(code);
            if (item == null) {
                return null;
            }
            return item.getItemMeta();
        }

        public static String getItemCode(ItemStack item) {
            return ChestShop.getItemDatabase().getItemCode(item);
        }
    }

    private static class YamlBukkitConstructor
    extends YamlConstructor {
        public YamlBukkitConstructor() {
            this.yamlConstructors.put(new Tag("tag:yaml.org,2002:org.bukkit.inventory.ItemStack"), (Construct)this.yamlConstructors.get(Tag.MAP));
        }
    }

    public static class Show {
        private static ShowItem showItem = null;

        public static void initialize(Plugin plugin) {
            showItem = (ShowItem)plugin;
        }

        public static boolean sendMessage(Player player, Messages.Message message, ItemStack[] stock, Map<String, String> replacementMap, String ... replacements) {
            return Show.sendMessage(player, player.getName(), message, stock, replacementMap, replacements);
        }

        public static boolean sendMessage(Player player, String playerName, Messages.Message message, ItemStack[] stock, Map<String, String> replacementMap, String ... replacements) {
            return Show.sendMessage(player, playerName, message, true, stock, replacementMap, replacements);
        }

        public static boolean sendMessage(Player player, String playerName, Messages.Message message, boolean showPrefix, ItemStack[] stock, Map<String, String> replacementMap, String ... replacements) {
            if (showItem == null) {
                return false;
            }
            TextComponent.Builder itemComponent = Component.text();
            for (Map.Entry<ItemStack, Integer> entry : InventoryUtil.getItemCounts(stock).entrySet()) {
                try {
                    ItemStack item = entry.getKey();
                    if (item == null || item.getType() == Material.AIR || entry.getValue() <= 0) continue;
                    if (entry.getValue() < item.getMaxStackSize()) {
                        item.setAmount(entry.getValue().intValue());
                    }
                    itemComponent.append((Component)GsonComponentSerializer.gson().deserialize(showItem.getItemConverter().createComponent(item, Level.FINE).toJsonString(player)));
                }
                catch (Exception e) {
                    ChestShop.getPlugin().getLogger().log(Level.WARNING, "Error while trying to send message '" + message + "' to player " + player.getName() + ": " + e.getMessage());
                    return false;
                }
            }
            LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>(replacementMap);
            newMap.put("material", "item");
            newMap.remove("item");
            Component component = new Replacer().placeholderSuffix("").replace("item", (Component)itemComponent.build()).replaceIn(message.getComponent((CommandSender)player, showPrefix, newMap, replacements));
            if (player != null) {
                ChestShop.getAudiences().player(player).sendMessage(component);
                return true;
            }
            if (playerName != null) {
                ChestShop.sendBungeeMessage(playerName, component);
                return true;
            }
            return true;
        }
    }
}

