/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryUtil {
    private static Boolean legacyContents = null;

    private static ItemStack[] getStorageContents(Inventory inventory) {
        if (legacyContents == null) {
            try {
                inventory.getStorageContents();
                legacyContents = false;
            }
            catch (NoSuchMethodError e) {
                legacyContents = true;
            }
        }
        return legacyContents != false ? inventory.getContents() : inventory.getStorageContents();
    }

    public static int getAmount(ItemStack item, Inventory inventory) {
        if (!inventory.contains(item.getType())) {
            return 0;
        }
        if (inventory.getType() == null) {
            return Integer.MAX_VALUE;
        }
        HashMap items = inventory.all(item.getType());
        int itemAmount = 0;
        for (ItemStack iStack : items.values()) {
            if (!MaterialUtil.equals(iStack, item)) continue;
            itemAmount += iStack.getAmount();
        }
        return itemAmount;
    }

    public static boolean isEmpty(Inventory inventory) {
        for (ItemStack stack : InventoryUtil.getStorageContents(inventory)) {
            if (MaterialUtil.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    public static int countEmpty(Inventory inventory) {
        int emptyAmount = 0;
        for (ItemStack stack : InventoryUtil.getStorageContents(inventory)) {
            if (!MaterialUtil.isEmpty(stack)) continue;
            ++emptyAmount;
        }
        return emptyAmount;
    }

    public static boolean hasItems(ItemStack[] items, Inventory inventory) {
        Map<ItemStack, Integer> itemCounts = InventoryUtil.getItemCounts(items);
        for (Map.Entry<ItemStack, Integer> entry : itemCounts.entrySet()) {
            if (InventoryUtil.getAmount(entry.getKey(), inventory) >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean fits(ItemStack[] items, Inventory inventory) {
        Map<ItemStack, Integer> itemCounts = InventoryUtil.getItemCounts(items);
        for (Map.Entry<ItemStack, Integer> entry : itemCounts.entrySet()) {
            if (InventoryUtil.fits(entry.getKey(), entry.getValue(), inventory)) continue;
            return false;
        }
        return true;
    }

    public static boolean fits(ItemStack item, Inventory inventory) {
        return InventoryUtil.fits(item, item.getAmount(), inventory);
    }

    public static boolean fits(ItemStack item, int amount, Inventory inventory) {
        int left = amount;
        if (inventory.getSize() == Integer.MAX_VALUE) {
            return true;
        }
        for (ItemStack iStack : InventoryUtil.getStorageContents(inventory)) {
            if (left <= 0) {
                return true;
            }
            if (MaterialUtil.isEmpty(iStack)) {
                left -= InventoryUtil.getMaxStackSize(item);
                continue;
            }
            if (!MaterialUtil.equals(iStack, item)) continue;
            left -= InventoryUtil.getMaxStackSize(iStack) - iStack.getAmount();
        }
        return left <= 0;
    }

    public static int transfer(ItemStack item, Inventory sourceInventory, Inventory targetInventory) {
        return InventoryUtil.transfer(item, sourceInventory, targetInventory, item.getMaxStackSize());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int transfer(ItemStack item, Inventory sourceInventory, Inventory targetInventory, int maxStackSize) {
        if (item.getAmount() < 1) {
            return 0;
        }
        int amount = item.getAmount();
        for (ItemStack currentItem : sourceInventory) {
            if (MaterialUtil.equals(currentItem, item)) {
                ItemStack clone = currentItem.clone();
                if (currentItem.getAmount() >= amount) {
                    clone.setAmount(amount);
                    amount = 0;
                } else {
                    clone.setAmount(currentItem.getAmount());
                    amount -= clone.getAmount();
                }
                int leftOver = InventoryUtil.add(clone, targetInventory, maxStackSize);
                if (leftOver > 0) {
                    currentItem.setAmount(currentItem.getAmount() - clone.getAmount() + leftOver);
                    if (amount <= 0) return leftOver;
                    amount += leftOver;
                } else {
                    currentItem.setAmount(currentItem.getAmount() - clone.getAmount());
                }
            }
            if (amount > 0) continue;
            return amount;
        }
        return amount;
    }

    public static int add(ItemStack item, Inventory inventory, int maxStackSize) {
        if (item.getAmount() < 1) {
            return 0;
        }
        if (maxStackSize == item.getMaxStackSize()) {
            return InventoryUtil.add(item, inventory);
        }
        return InventoryUtil.addManually(item, inventory, maxStackSize);
    }

    private static int addManually(ItemStack item, Inventory inventory, int maxStackSize) {
        int amountLeft = item.getAmount();
        for (int currentSlot = 0; currentSlot < InventoryUtil.effectiveSize(inventory) && amountLeft > 0; ++currentSlot) {
            ItemStack currentItem = inventory.getItem(currentSlot);
            if (MaterialUtil.isEmpty(currentItem)) {
                currentItem = new ItemStack(item);
                currentItem.setAmount(Math.min(amountLeft, maxStackSize));
                inventory.setItem(currentSlot, currentItem);
                amountLeft -= currentItem.getAmount();
                continue;
            }
            if (currentItem.getAmount() >= maxStackSize || !MaterialUtil.equals(currentItem, item)) continue;
            int neededToAdd = Math.min(maxStackSize - currentItem.getAmount(), amountLeft);
            currentItem.setAmount(currentItem.getAmount() + neededToAdd);
            amountLeft -= neededToAdd;
        }
        return amountLeft;
    }

    private static int effectiveSize(Inventory inventory) {
        return InventoryUtil.getStorageContents(inventory).length;
    }

    public static int add(ItemStack item, Inventory inventory) {
        HashMap leftovers = inventory.addItem(new ItemStack[]{item.clone()});
        if (!leftovers.isEmpty()) {
            Iterator iterator = leftovers.values().iterator();
            while (iterator.hasNext()) {
                ItemStack left = (ItemStack)iterator.next();
                int amountLeft = InventoryUtil.addManually(left, inventory, left.getMaxStackSize());
                if (amountLeft == 0) {
                    iterator.remove();
                    continue;
                }
                left.setAmount(amountLeft);
            }
        }
        return InventoryUtil.countItems(leftovers);
    }

    public static int remove(ItemStack item, Inventory inventory) {
        HashMap leftovers = inventory.removeItem(new ItemStack[]{item});
        if (!leftovers.isEmpty()) {
            leftovers.values().removeIf(left -> InventoryUtil.removeManually(left, inventory) == 0);
        }
        return InventoryUtil.countItems(leftovers);
    }

    private static int removeManually(ItemStack item, Inventory inventory) {
        int amountLeft = item.getAmount();
        for (int currentSlot = 0; currentSlot < InventoryUtil.effectiveSize(inventory) && amountLeft > 0; ++currentSlot) {
            ItemStack currentItem = inventory.getItem(currentSlot);
            if (currentItem == null || !MaterialUtil.equals(currentItem, item)) continue;
            int neededToRemove = Math.min(currentItem.getAmount(), amountLeft);
            currentItem.setAmount(currentItem.getAmount() - neededToRemove);
            inventory.setItem(currentSlot, currentItem);
            amountLeft -= neededToRemove;
        }
        return amountLeft;
    }

    @Deprecated
    public static ItemStack[] mergeSimilarStacks(ItemStack ... items) {
        if (items.length <= 1) {
            return items;
        }
        LinkedList<ItemStack> itemList = new LinkedList<ItemStack>();
        block0: for (ItemStack item : items) {
            for (ItemStack iStack : itemList) {
                if (!MaterialUtil.equals(item, iStack)) continue;
                iStack.setAmount(iStack.getAmount() + item.getAmount());
                continue block0;
            }
            itemList.add(item.clone());
        }
        return itemList.toArray(new ItemStack[0]);
    }

    public static Map<ItemStack, Integer> getItemCounts(ItemStack ... items) {
        if (items == null || items.length == 0) {
            return Collections.emptyMap();
        }
        if (items.length == 1) {
            ItemStack itemClone = items[0].clone();
            itemClone.setAmount(1);
            return ImmutableMap.of((Object)itemClone, (Object)items[0].getAmount());
        }
        LinkedHashMap<ItemStack, Integer> counts = new LinkedHashMap<ItemStack, Integer>();
        block0: for (ItemStack item : items) {
            for (Map.Entry entry : counts.entrySet()) {
                if (!MaterialUtil.equals(item, (ItemStack)entry.getKey())) continue;
                entry.setValue((Integer)entry.getValue() + item.getAmount());
                continue block0;
            }
            ItemStack itemClone = item.clone();
            itemClone.setAmount(1);
            counts.put(itemClone, item.getAmount());
        }
        return counts;
    }

    public static int countItems(ItemStack ... items) {
        int count = 0;
        for (ItemStack item : items) {
            count += item.getAmount();
        }
        return count;
    }

    public static int countItems(Map<Integer, ItemStack> items) {
        int totalLeft = 0;
        for (ItemStack left : items.values()) {
            totalLeft += left.getAmount();
        }
        return totalLeft;
    }

    public static int getMaxStackSize(ItemStack item) {
        return Properties.STACK_TO_64 ? 64 : item.getMaxStackSize();
    }

    public static ItemStack[] getItemsStacked(ItemStack ... items) {
        LinkedList<ItemStack> stackedItems = new LinkedList<ItemStack>();
        for (ItemStack item : items) {
            InventoryUtil.stackItems(stackedItems, item, item.getAmount());
        }
        return stackedItems.toArray(new ItemStack[0]);
    }

    public static ItemStack[] getItemStacked(ItemStack item, int amount) {
        return InventoryUtil.stackItems(new LinkedList<ItemStack>(), item, amount).toArray(new ItemStack[0]);
    }

    private static Collection<ItemStack> stackItems(Collection<ItemStack> stackedItems, ItemStack item, int amount) {
        int maxStackSize = InventoryUtil.getMaxStackSize(item);
        if (maxStackSize == 0) {
            return stackedItems;
        }
        ItemStack itemClone = item.clone();
        for (ItemStack stackedItem : stackedItems) {
            if (!MaterialUtil.equals(stackedItem, itemClone) || stackedItem.getAmount() >= InventoryUtil.getMaxStackSize(stackedItem)) continue;
            int amountToAdd = Math.min(InventoryUtil.getMaxStackSize(stackedItem) - stackedItem.getAmount(), amount);
            stackedItem.setAmount(stackedItem.getAmount() + amountToAdd);
            if ((amount -= amountToAdd) > 0) continue;
            break;
        }
        if (amount > maxStackSize || amount <= 0) {
            int i = 0;
            while ((double)i < Math.floor((double)amount / (double)maxStackSize)) {
                ItemStack itemAddClone = itemClone.clone();
                itemAddClone.setAmount(maxStackSize);
                stackedItems.add(itemAddClone);
                ++i;
            }
            amount %= maxStackSize;
        }
        if (amount > 0) {
            itemClone.setAmount(amount);
            stackedItems.add(itemClone);
        }
        return stackedItems;
    }
}

