/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import java.util.function.BiFunction;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class ImplementationAdapter {
    private static BiFunction<Inventory, Boolean, InventoryHolder> HOLDER_PROVIDER;
    private static BiFunction<DoubleChest, Boolean, InventoryHolder> LEFT_HOLDER_PROVIDER;
    private static BiFunction<DoubleChest, Boolean, InventoryHolder> RIGHT_HOLDER_PROVIDER;
    private static BiFunction<Block, Boolean, BlockState> STATE_PROVIDER;

    public static InventoryHolder getHolder(Inventory inventory, boolean useSnapshot) {
        return HOLDER_PROVIDER.apply(inventory, useSnapshot);
    }

    public static InventoryHolder getLeftSide(DoubleChest doubleChest, boolean useSnapshot) {
        return LEFT_HOLDER_PROVIDER.apply(doubleChest, useSnapshot);
    }

    public static InventoryHolder getRightSide(DoubleChest doubleChest, boolean useSnapshot) {
        return RIGHT_HOLDER_PROVIDER.apply(doubleChest, useSnapshot);
    }

    public static BlockState getState(Block block, boolean useSnapshot) {
        return STATE_PROVIDER.apply(block, useSnapshot);
    }

    static {
        Class<?> c;
        try {
            Inventory.class.getMethod("getHolder", Boolean.TYPE);
            c = Class.forName("com.Acrobot.Breeze.Utils.ImplementationFeatures.NonSnapshotInventoryHolder");
            HOLDER_PROVIDER = (BiFunction)c.getDeclaredField("PROVIDER").get(null);
            LEFT_HOLDER_PROVIDER = (BiFunction)c.getDeclaredField("LEFT_PROVIDER").get(null);
            RIGHT_HOLDER_PROVIDER = (BiFunction)c.getDeclaredField("RIGHT_PROVIDER").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            HOLDER_PROVIDER = (inventory, useSnapshot) -> inventory.getHolder();
            LEFT_HOLDER_PROVIDER = (doubleChest, useSnapshot) -> doubleChest.getLeftSide();
            RIGHT_HOLDER_PROVIDER = (doubleChest, useSnapshot) -> doubleChest.getRightSide();
        }
        try {
            Block.class.getMethod("getState", Boolean.TYPE);
            c = Class.forName("com.Acrobot.Breeze.Utils.ImplementationFeatures.NonSnapshotState");
            STATE_PROVIDER = (BiFunction)c.getDeclaredField("PROVIDER").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            STATE_PROVIDER = (block, useSnapshot) -> block.getState();
        }
    }
}

