/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class BlockUtil {
    public static boolean isSign(Block block) {
        if (!BlockUtil.isLoaded(block)) {
            return false;
        }
        BlockData data = block.getBlockData();
        return data instanceof org.bukkit.block.data.type.Sign || data instanceof WallSign;
    }

    public static boolean isChest(Block block) {
        return BlockUtil.isLoaded(block) && block.getBlockData() instanceof Chest;
    }

    public static boolean isChest(InventoryHolder holder) {
        return holder instanceof org.bukkit.block.Chest || holder instanceof DoubleChest;
    }

    public static Block getAttachedBlock(Sign sign) {
        BlockFace direction;
        BlockData blockData = sign.getBlockData();
        if (blockData instanceof WallSign) {
            direction = ((Directional)blockData).getFacing().getOppositeFace();
        } else if (blockData instanceof org.bukkit.block.data.type.Sign) {
            direction = BlockFace.DOWN;
        } else {
            throw new IllegalArgumentException("Cannot get direction of " + blockData.getClass().getSimpleName());
        }
        return sign.getBlock().getRelative(direction);
    }

    public static BlockFace getMajorDirection(BlockFace face) {
        switch (face) {
            case NORTH_WEST: 
            case NORTH_NORTH_WEST: 
            case NORTH_NORTH_EAST: {
                return BlockFace.NORTH;
            }
            case NORTH_EAST: 
            case EAST_NORTH_EAST: 
            case EAST_SOUTH_EAST: {
                return BlockFace.EAST;
            }
            case SOUTH_EAST: 
            case SOUTH_SOUTH_EAST: 
            case SOUTH_SOUTH_WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH_WEST: 
            case WEST_NORTH_WEST: 
            case WEST_SOUTH_WEST: {
                return BlockFace.WEST;
            }
        }
        return face;
    }

    public static boolean openBlockGUI(InventoryHolder holder, Player player) {
        Inventory inventory = holder.getInventory();
        player.openInventory(inventory);
        return true;
    }

    public static boolean isLoaded(Block block) {
        return block.getWorld().isChunkLoaded(block.getX() >> 4, block.getZ() >> 4);
    }
}

