/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;

public class ValueParser {
    public String parseToYAML(Object object) {
        if (object instanceof Number || object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            for (Object o : (Collection)object) {
                sb.append("\n- ").append(this.parseToYAML(o));
            }
            return sb.toString();
        }
        if (object instanceof String) {
            String[] lines = ((String)object).split("\\R");
            if (lines.length == 1) {
                return '\"' + String.valueOf(object).replace("\\", "\\\\") + '\"';
            }
            return "|-\n" + Arrays.stream(lines).map(s -> "  " + s.replace("\\", "\\\\")).collect(Collectors.joining("\n"));
        }
        return '\"' + String.valueOf(object) + '\"';
    }

    public <T> Object parseToJava(Class<T> type, Object object) {
        if (object instanceof ConfigurationSection) {
            HashMap<String, List> map = new HashMap<String, List>();
            for (String message : ((ConfigurationSection)object).getKeys(false)) {
                map.put(message, ((ConfigurationSection)object).getStringList(message));
            }
            return map;
        }
        return object;
    }
}

