/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Configuration;

import com.Acrobot.Breeze.Configuration.Annotations.Parser;
import com.Acrobot.Breeze.Configuration.Annotations.PrecededBySpace;
import com.Acrobot.Breeze.Configuration.FieldParser;
import com.Acrobot.Breeze.Configuration.ValueParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public class Configuration {
    private static Map<String, ValueParser> parsers = new HashMap<String, ValueParser>();
    private static final ValueParser DEFAULT_PARSER = new ValueParser();
    private static final ValueParser ENUM_PARSER = new ValueParser(){

        @Override
        public <T> Object parseToJava(Class<T> type, Object object) {
            if (object instanceof String && type.isEnum()) {
                return Enum.valueOf(type, ((String)object).toUpperCase(Locale.ROOT));
            }
            return object;
        }
    };

    public static void pairFileAndClass(File file, Class<?> clazz) {
        Configuration.pairFileAndClass(file, clazz, Bukkit.getLogger());
    }

    public static void pairFileAndClass(File file, Class<?> clazz, Logger logger) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        boolean debug = config.getBoolean("DEBUG", false);
        if (debug) {
            logger.log(Level.INFO, "Loading configuration " + file.getName());
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
            if (!Configuration.endsWithSpace(file)) {
                writer.newLine();
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) {
                    if (!debug) continue;
                    logger.log(Level.WARNING, "Field " + field.getName() + " is private, transient or not static!");
                    continue;
                }
                String path = field.getName();
                try {
                    if (config.isSet(path)) {
                        field.set(null, Configuration.getParser(field).parseToJava(field.getType(), config.get(path)));
                    } else if (config.isSet(path.toLowerCase(Locale.ROOT))) {
                        field.set(null, Configuration.getParser(field).parseToJava(field.getType(), config.get(path.toLowerCase(Locale.ROOT))));
                    } else {
                        if (field.isAnnotationPresent(PrecededBySpace.class)) {
                            writer.newLine();
                        }
                        writer.write(FieldParser.parse(field));
                        writer.newLine();
                    }
                    if (!debug) continue;
                    logger.log(Level.INFO, field.getName() + ": " + Configuration.getParser(field).parseToYAML(field.get(null)));
                }
                catch (IOException | IllegalAccessException | IllegalArgumentException e) {
                    logger.log(Level.SEVERE, "Error while loading field " + field.getName() + " in configuration " + file.getName(), e);
                }
            }
            writer.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while loading configuration " + file.getName(), e);
        }
    }

    public static boolean endsWithSpace(File file) {
        Scanner scanner = new Scanner(file);
        try {
            String lastLine = "";
            while (scanner.hasNextLine()) {
                lastLine = scanner.nextLine();
            }
            boolean bl = lastLine.isEmpty();
            scanner.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                Logger.getLogger("Configuration").log(Level.SEVERE, "Error while checking if file " + file.getName() + " ends with space", e);
                return false;
            }
        }
    }

    public static String parseToConfig(Object value) {
        return DEFAULT_PARSER.parseToYAML(value);
    }

    public static String getColoured(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static void registerParser(String name, ValueParser valueParser) {
        parsers.put(name.toLowerCase(Locale.ROOT), valueParser);
    }

    public static ValueParser getParser(String name) {
        return parsers.get(name.toLowerCase(Locale.ROOT));
    }

    public static ValueParser getParser(Field field) {
        ValueParser parser = null;
        if (field.isAnnotationPresent(Parser.class)) {
            parser = Configuration.getParser(field.getAnnotation(Parser.class).value());
        }
        if (parser == null) {
            parser = Configuration.getParser(field.getType().getSimpleName());
        }
        if (parser == null && field.getType().isEnum()) {
            parser = ENUM_PARSER;
        }
        if (parser == null) {
            parser = DEFAULT_PARSER;
        }
        return parser;
    }
}

