/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.util.chat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;

public class ChatUtil {
    private static final String NON_UNICODE_CHARS = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    private static final int[] NON_UNICODE_CHAR_WIDTHS = new int[]{6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6, 6, 6, 6, 6, 4, 4, 6, 7, 6, 6, 6, 6, 6, 6, 1, 1, 1, 1, 1, 1, 1, 4, 2, 5, 6, 6, 6, 6, 3, 5, 5, 5, 6, 2, 6, 2, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 2, 2, 5, 6, 5, 6, 7, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 4, 6, 6, 3, 6, 6, 6, 6, 6, 5, 6, 6, 2, 6, 5, 3, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6, 6, 6, 5, 2, 5, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 3, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 3, 6, 6, 6, 6, 6, 6, 6, 7, 6, 6, 6, 2, 6, 6, 8, 9, 9, 6, 6, 6, 8, 8, 6, 8, 8, 8, 8, 8, 6, 6, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 6, 9, 9, 9, 5, 9, 9, 8, 7, 7, 8, 7, 8, 8, 8, 7, 8, 8, 7, 9, 9, 6, 7, 7, 7, 7, 7, 9, 6, 7, 8, 7, 6, 6, 9, 7, 6, 7, 1};
    private static final byte[] UNICODE_CHAR_WIDTHS = new byte[65536];
    public static final int DEFAULT_CHAT_LINE_WIDTH = 320;
    private static final Pattern pattern;
    private static final Pattern strip_bbcode_pattern;
    private static final Logger logger;

    public static BaseComponent[] parseBBCode(String text) {
        Matcher matcher = pattern.matcher(text);
        TextComponent current = new TextComponent();
        LinkedList<TextComponent> components = new LinkedList<TextComponent>();
        int forceBold = 0;
        int forceItalic = 0;
        int forceUnderlined = 0;
        int forceStrikethrough = 0;
        int nocolorLevel = 0;
        int nobbcodeLevel = 0;
        LinkedList<ChatColor> colorDeque = new LinkedList<ChatColor>();
        LinkedList<ClickEvent> clickEventDeque = new LinkedList<ClickEvent>();
        LinkedList<HoverEvent> hoverEventDeque = new LinkedList<HoverEvent>();
        while (matcher.find()) {
            ClickEvent clickEvent;
            ClickEvent clickEvent2;
            String url;
            ChatColor color;
            boolean parsed = false;
            StringBuffer stringBuffer = new StringBuffer();
            matcher.appendReplacement(stringBuffer, "");
            TextComponent component = new TextComponent(current);
            current.setText(stringBuffer.toString());
            components.add(current);
            current = component;
            String group_color = matcher.group("color");
            String group_tag = matcher.group("tag");
            String group_value = matcher.group("value");
            String group_implicitTag = matcher.group("implicitTag");
            String group_implicitValue = matcher.group("implicitValue");
            if (group_color != null && nocolorLevel <= 0 && (color = ChatColor.getByChar((char)group_color.charAt(0))) != null) {
                switch (color) {
                    case MAGIC: {
                        current.setObfuscated(Boolean.valueOf(true));
                        break;
                    }
                    case BOLD: {
                        current.setBold(Boolean.valueOf(true));
                        break;
                    }
                    case STRIKETHROUGH: {
                        current.setStrikethrough(Boolean.valueOf(true));
                        break;
                    }
                    case UNDERLINE: {
                        current.setUnderlined(Boolean.valueOf(true));
                        break;
                    }
                    case ITALIC: {
                        current.setItalic(Boolean.valueOf(true));
                        break;
                    }
                    case RESET: {
                        color = ChatColor.WHITE;
                    }
                    default: {
                        current = new TextComponent();
                        current.setColor(color);
                        current.setBold(Boolean.valueOf(forceBold > 0));
                        current.setItalic(Boolean.valueOf(forceItalic > 0));
                        current.setUnderlined(Boolean.valueOf(forceUnderlined > 0));
                        current.setStrikethrough(Boolean.valueOf(forceStrikethrough > 0));
                        if (!colorDeque.isEmpty()) {
                            current.setColor((ChatColor)colorDeque.peek());
                        }
                        if (!clickEventDeque.isEmpty()) {
                            current.setClickEvent((ClickEvent)clickEventDeque.peek());
                        }
                        if (hoverEventDeque.isEmpty()) break;
                        current.setHoverEvent((HoverEvent)hoverEventDeque.peek());
                    }
                }
                parsed = true;
            }
            if (group_tag != null && nobbcodeLevel <= 0) {
                if (group_tag.matches("(?is)^b$")) {
                    if (++forceBold > 0) {
                        current.setBold(Boolean.valueOf(true));
                    } else {
                        current.setBold(Boolean.valueOf(false));
                    }
                    parsed = true;
                } else if (group_tag.matches("(?is)^/b$")) {
                    if (--forceBold <= 0) {
                        current.setBold(Boolean.valueOf(false));
                    } else {
                        current.setBold(Boolean.valueOf(true));
                    }
                    parsed = true;
                }
                if (group_tag.matches("(?is)^i$")) {
                    if (++forceItalic > 0) {
                        current.setItalic(Boolean.valueOf(true));
                    } else {
                        current.setItalic(Boolean.valueOf(false));
                    }
                    parsed = true;
                } else if (group_tag.matches("(?is)^/i$")) {
                    if (--forceItalic <= 0) {
                        current.setItalic(Boolean.valueOf(false));
                    } else {
                        current.setItalic(Boolean.valueOf(true));
                    }
                    parsed = true;
                }
                if (group_tag.matches("(?is)^u$")) {
                    if (++forceUnderlined > 0) {
                        current.setUnderlined(Boolean.valueOf(true));
                    } else {
                        current.setUnderlined(Boolean.valueOf(false));
                    }
                    parsed = true;
                } else if (group_tag.matches("(?is)^/u$")) {
                    if (--forceUnderlined <= 0) {
                        current.setUnderlined(Boolean.valueOf(false));
                    } else {
                        current.setUnderlined(Boolean.valueOf(true));
                    }
                    parsed = true;
                }
                if (group_tag.matches("(?is)^s$")) {
                    if (++forceStrikethrough > 0) {
                        current.setStrikethrough(Boolean.valueOf(true));
                    } else {
                        current.setStrikethrough(Boolean.valueOf(false));
                    }
                    parsed = true;
                } else if (group_tag.matches("(?is)^/s$")) {
                    if (--forceStrikethrough <= 0) {
                        current.setStrikethrough(Boolean.valueOf(false));
                    } else {
                        current.setStrikethrough(Boolean.valueOf(true));
                    }
                    parsed = true;
                }
                if (group_tag.matches("(?is)^color=.*$")) {
                    color = null;
                    for (ChatColor color1 : ChatColor.values()) {
                        if (!color1.getName().equalsIgnoreCase(group_value)) continue;
                        color = color1;
                    }
                    colorDeque.push(current.getColor());
                    if (color != null && color != ChatColor.BOLD && color != ChatColor.ITALIC && color != ChatColor.MAGIC && color != ChatColor.RESET && color != ChatColor.STRIKETHROUGH && color != ChatColor.UNDERLINE) {
                        colorDeque.push(color);
                        current.setColor(color);
                    } else {
                        logger.warning("Invalid color tag: [" + group_tag + "] UNKNOWN COLOR '" + group_value + "'");
                        colorDeque.push(ChatColor.WHITE);
                        current.setColor(ChatColor.WHITE);
                    }
                    parsed = true;
                } else if (group_tag.matches("(?is)^/color$")) {
                    if (!colorDeque.isEmpty()) {
                        colorDeque.pop();
                        current.setColor((ChatColor)colorDeque.pop());
                    }
                    parsed = true;
                }
                if (group_tag.matches("(?is)^url=.*$")) {
                    url = group_value;
                    if (!(url = url.replaceAll("(?is)\\[/?nobbcode\\]", "")).startsWith("http")) {
                        url = "http://" + url;
                    }
                    clickEvent2 = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
                    clickEventDeque.push(clickEvent2);
                    current.setClickEvent(clickEvent2);
                    parsed = true;
                }
                if (group_tag.matches("(?is)^/(?:url|command|suggest)$")) {
                    if (!clickEventDeque.isEmpty()) {
                        clickEventDeque.pop();
                    }
                    if (clickEventDeque.isEmpty()) {
                        current.setClickEvent(null);
                    } else {
                        current.setClickEvent((ClickEvent)clickEventDeque.peek());
                    }
                    parsed = true;
                }
                if (group_tag.matches("(?is)^command=.*")) {
                    group_value = group_value.replaceAll("(?is)\\[/?nobbcode\\]", "");
                    clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, group_value);
                    clickEventDeque.push(clickEvent);
                    current.setClickEvent(clickEvent);
                    parsed = true;
                }
                if (group_tag.matches("(?is)^suggest=.*")) {
                    group_value = group_value.replaceAll("(?is)\\[/?nobbcode\\]", "");
                    clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, group_value);
                    clickEventDeque.push(clickEvent);
                    current.setClickEvent(clickEvent);
                    parsed = true;
                }
                if (group_tag.matches("(?is)^hover=.*$")) {
                    BaseComponent[] components1 = ChatUtil.parseBBCode(group_value);
                    if (!hoverEventDeque.isEmpty()) {
                        BaseComponent[] components2 = ((HoverEvent)hoverEventDeque.getLast()).getValue();
                        BaseComponent[] components3 = new BaseComponent[components1.length + components2.length + 1];
                        int i = 0;
                        for (BaseComponent baseComponent : components2) {
                            components3[i++] = baseComponent;
                        }
                        components3[i++] = new TextComponent("\n");
                        for (BaseComponent baseComponent : components1) {
                            components3[i++] = baseComponent;
                        }
                        components1 = components3;
                    }
                    HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, components1);
                    hoverEventDeque.push(hoverEvent);
                    current.setHoverEvent(hoverEvent);
                    parsed = true;
                } else if (group_tag.matches("(?is)^/hover$")) {
                    if (!hoverEventDeque.isEmpty()) {
                        hoverEventDeque.pop();
                    }
                    if (hoverEventDeque.isEmpty()) {
                        current.setHoverEvent(null);
                    } else {
                        current.setHoverEvent((HoverEvent)hoverEventDeque.peek());
                    }
                    parsed = true;
                }
            }
            if (group_implicitTag != null && nobbcodeLevel <= 0) {
                if (group_implicitTag.matches("(?is)^url$")) {
                    url = group_implicitValue;
                    if (!url.startsWith("http")) {
                        url = "http://" + url;
                    }
                    clickEvent2 = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
                    clickEventDeque.push(clickEvent2);
                    current.setClickEvent(clickEvent2);
                    parsed = true;
                }
                if (group_implicitTag.matches("(?is)^command$")) {
                    clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, group_implicitValue);
                    clickEventDeque.push(clickEvent);
                    current.setClickEvent(clickEvent);
                    parsed = true;
                }
                if (group_implicitTag.matches("(?is)^suggest$")) {
                    clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, group_implicitValue);
                    clickEventDeque.push(clickEvent);
                    current.setClickEvent(clickEvent);
                    parsed = true;
                }
            }
            if (group_tag != null) {
                if (group_tag.matches("(?is)^nocolor$")) {
                    ++nocolorLevel;
                    parsed = true;
                }
                if (group_tag.matches("(?is)^/nocolor$")) {
                    --nocolorLevel;
                    parsed = true;
                }
                if (group_tag.matches("(?is)^nobbcode$")) {
                    ++nobbcodeLevel;
                    parsed = true;
                }
                if (group_tag.matches("(?is)^/nobbcode$")) {
                    --nobbcodeLevel;
                    parsed = true;
                }
            }
            if (parsed) continue;
            TextComponent component2 = new TextComponent(current);
            current.setText(matcher.group(0));
            components.add(current);
            current = component2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        matcher.appendTail(stringBuffer);
        current.setText(stringBuffer.toString());
        components.add(current);
        return components.toArray(new BaseComponent[components.size()]);
    }

    public static String stripBBCode(String string) {
        return strip_bbcode_pattern.matcher(string).replaceAll("");
    }

    public static double getCharWidth(int codePoint, boolean isBold) {
        double width;
        int nonUnicodeIdx = NON_UNICODE_CHARS.indexOf(codePoint);
        if (nonUnicodeIdx != -1) {
            width = NON_UNICODE_CHAR_WIDTHS[nonUnicodeIdx];
            if (isBold) {
                width += 1.0;
            }
        } else {
            int j = UNICODE_CHAR_WIDTHS[codePoint] >>> 4;
            int k = UNICODE_CHAR_WIDTHS[codePoint] & 0xF;
            if (k > 7) {
                k = 15;
                j = 0;
            }
            width = (k + 1 - j) / 2 + 1;
            if (isBold) {
                width += 0.5;
            }
        }
        return width;
    }

    public static int getLength(BaseComponent[] text) {
        double length = 0.0;
        for (BaseComponent child : text) {
            if (!(child instanceof TextComponent)) continue;
            String txt = ((TextComponent)child).getText();
            boolean isBold = child.isBold();
            for (int i = 0; i < txt.length(); ++i) {
                length += ChatUtil.getCharWidth(txt.codePointAt(i), isBold);
            }
        }
        return (int)Math.ceil(length);
    }

    static {
        InputStream resourceAsStream = ChatUtil.class.getResourceAsStream("unicode.txt");
        InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String line;
            int i = 0;
            while ((line = bufferedReader.readLine()) != null) {
                ChatUtil.UNICODE_CHAR_WIDTHS[i++] = Byte.valueOf(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        pattern = Pattern.compile("(?is)(?=\\n)|(?:[&\u00a7](?<color>[0-9A-FK-OR]))|(?:\\[(?<tag>/?(?:b|i|u|s|nocolor|nobbcode)|(?:url|command|hover|suggest|color)=(?<value>(?:(?:[^]\\[]*)\\[(?:[^]\\[]*)\\])*(?:[^]\\[]*))|/(?:url|command|hover|suggest|color))\\])|(?:\\[(?<implicitTag>url|command|suggest)\\](?=(?<implicitValue>.*?)\\[/\\k<implicitTag>\\]))");
        strip_bbcode_pattern = Pattern.compile("(?is)(?:\\[(?<tag>/?(?:b|i|u|s|nocolor|nobbcode)|(?:url|command|hover|suggest|color)=(?<value>(?:(?:[^]\\[]*)\\[(?:[^]\\[]*)\\])*(?:[^]\\[]*))|/(?:url|command|hover|suggest|color))\\])|(?:\\[(?<implicitTag>url|command|suggest)\\](?=(?<implicitValue>.*?)\\[/\\k<implicitTag>\\]))");
        logger = Logger.getLogger("Minecraft");
    }
}

