/*
 * Decompiled with CFR 0.152.
 */
package ca.bkaw.papernmsmavenplugin;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.json.JSONTokener;

public class RemappedClasses {
    public static final String FILE_NAME = "classes.json";
    private final Path jsonFile;
    private final Path classesFolder;
    private final Map<Path, Long> lastModifiedTimes = new HashMap<Path, Long>();

    public RemappedClasses(Path jsonFile, Path classesFolder) throws IOException {
        this.jsonFile = jsonFile;
        this.classesFolder = classesFolder;
        if (Files.exists(jsonFile, new LinkOption[0])) {
            JSONObject config = new JSONObject(new JSONTokener(Files.newInputStream(jsonFile, new OpenOption[0])));
            for (String key : config.keySet()) {
                Path path = classesFolder.resolve(key);
                long lastModifiedTime = config.getLong(key);
                this.lastModifiedTimes.put(path, lastModifiedTime);
            }
        }
    }

    private long getLastModifiedTime(Path path) throws IOException {
        return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
    }

    public boolean isAlreadyRemapped(Path classFilePath) throws IOException {
        Long lastRemapTime = this.lastModifiedTimes.get(classFilePath);
        if (lastRemapTime == null) {
            return false;
        }
        long lastModified = this.getLastModifiedTime(classFilePath);
        return lastModified == lastRemapTime;
    }

    public void markAsRemappedNow(Path classFilePath) throws IOException {
        this.lastModifiedTimes.put(classFilePath, this.getLastModifiedTime(classFilePath));
    }

    public void save() throws IOException {
        JSONObject json = new JSONObject();
        for (Map.Entry<Path, Long> entry : this.lastModifiedTimes.entrySet()) {
            Path path = entry.getKey();
            Path relativePath = this.classesFolder.relativize(path);
            json.put(relativePath.toString(), entry.getValue().longValue());
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.jsonFile, new OpenOption[0]);){
            json.write((Writer)writer);
        }
    }
}

